/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import com.mojang.datafixers.util.Pair;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.supplementaries.client.GlobeManager;
import net.mehvahdjukaar.supplementaries.common.block.blocks.GlobeBlock;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.mehvahdjukaar.supplementaries.reg.ModTextures;
import net.minecraft.class_1275;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlobeBlockTile
extends class_2586
implements class_1275 {
    private static final Pair<GlobeManager.Model, @Nullable class_2960> DEFAULT_DATA = Pair.of((Object)((Object)GlobeManager.Model.GLOBE), null);
    private final boolean sepia;
    private boolean sheared = false;
    private class_2561 customName;
    private float yaw = 0.0f;
    private float prevYaw = 0.0f;
    private Pair<GlobeManager.Model, @Nullable class_2960> renderData = DEFAULT_DATA;

    public GlobeBlockTile(class_2338 pos, class_2680 state) {
        super(ModRegistry.GLOBE_TILE.get(), pos, state);
        this.sepia = state.method_27852(ModRegistry.GLOBE_SEPIA.get());
    }

    public int getFaceRot() {
        return (3 - (Integer)this.method_11010().method_11654((class_2769)GlobeBlock.ROTATION)) * 90;
    }

    public float getRotation(float partialTicks) {
        int face = this.getFaceRot();
        return class_3532.method_16439((float)partialTicks, (float)(this.prevYaw + (float)face), (float)(this.yaw + (float)face));
    }

    @NotNull
    public Pair<GlobeManager.Model, class_2960> getRenderData() {
        return this.renderData;
    }

    public boolean isSepia() {
        return this.sepia;
    }

    public void setCustomName(class_2561 name) {
        this.customName = name;
        this.updateRenderData();
    }

    public void toggleShearing() {
        this.sheared = !this.sheared;
        this.updateRenderData();
    }

    private void updateRenderData() {
        Pair<GlobeManager.Model, class_2960> customData;
        this.renderData = this.sheared ? Pair.of((Object)((Object)GlobeManager.Model.SHEARED), (Object)(this.sepia ? ModTextures.GLOBE_SHEARED_SEPIA_TEXTURE : ModTextures.GLOBE_SHEARED_TEXTURE)) : (this.method_16914() ? ((customData = GlobeManager.Type.getModelAndTexture(this.method_5797().getString())) != null ? customData : DEFAULT_DATA) : DEFAULT_DATA);
    }

    public class_2561 method_5477() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    public class_2561 method_5797() {
        return this.customName;
    }

    public class_2561 getDefaultName() {
        return class_2561.method_43471((String)"block.supplementaries.globe");
    }

    public void method_11014(class_2487 compound) {
        if (compound.method_10573("CustomName", 8)) {
            this.setCustomName((class_2561)class_2561.class_2562.method_10877((String)compound.method_10558("CustomName")));
        }
        this.yaw = compound.method_10583("Yaw");
        this.sheared = compound.method_10577("Sheared");
        super.method_11014(compound);
        if (this.field_11863 != null && this.field_11863.field_9236) {
            this.updateRenderData();
        }
    }

    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        if (this.customName != null) {
            tag.method_10582("CustomName", class_2561.class_2562.method_10867((class_2561)this.customName));
        }
        tag.method_10548("Yaw", this.yaw);
        tag.method_10556("Sheared", this.sheared);
    }

    public void spin() {
        int spin = 360;
        int inc = 90;
        int face = (this.getFaceRot() - inc + 360) % 360;
        this.yaw = this.yaw + (float)spin + (float)inc;
        this.prevYaw = this.prevYaw + (float)spin + (float)inc;
        this.field_11863.method_8501(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)GlobeBlock.ROTATION, (Comparable)Integer.valueOf(3 - face / 90)));
        this.method_5431();
    }

    public boolean method_11004(int id, int type) {
        if (id == 1) {
            this.spin();
            this.field_11863.method_8396(null, this.field_11867, ModSounds.GLOBE_SPIN.get(), class_3419.field_15245, 0.65f, MthUtils.nextWeighted((class_5819)this.field_11863.field_9229, (float)0.2f) + 0.9f);
            return true;
        }
        if (id == 2) {
            this.field_11863.method_31595(this.field_11867, this.method_11010());
            return true;
        }
        return super.method_11004(id, type);
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public static void tick(class_1937 pLevel, class_2338 pPos, class_2680 pState, GlobeBlockTile tile) {
        tile.prevYaw = tile.yaw;
        if (tile.yaw != 0.0f) {
            if (tile.yaw < 0.0f) {
                tile.yaw = 0.0f;
                pLevel.method_8455(pPos, pState.method_26204());
            } else {
                tile.yaw = tile.yaw * 0.94f - 0.7f;
            }
        }
    }

    public class_2350 getDirection() {
        return (class_2350)this.method_11010().method_11654((class_2769)GlobeBlock.FACING);
    }

    public boolean isSpinningVeryFast() {
        return this.yaw > 1500.0f;
    }

    public int getSignalPower() {
        if (this.yaw != 0.0f) {
            return 15;
        }
        return this.getFaceRot() / 90 + 1;
    }
}

