/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import java.util.IdentityHashMap;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.block.ILightable;
import net.mehvahdjukaar.moonlight.api.client.util.ParticleUtil;
import net.mehvahdjukaar.supplementaries.common.block.blocks.AbstractPresentBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.PresentBlock;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.AlternativeBehavior;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.GenericProjectileBehavior;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.IFireItemBehavior;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.SpitItemBehavior;
import net.mehvahdjukaar.supplementaries.common.block.tiles.TrappedPresentBlockTile;
import net.minecraft.class_1297;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class TrappedPresentBlock
extends AbstractPresentBlock
implements ILightable {
    private static final Map<class_1792, IFireItemBehavior> FIRE_BEHAVIORS = new IdentityHashMap<class_1792, IFireItemBehavior>();
    private static final IFireItemBehavior DEFAULT = new AlternativeBehavior(new GenericProjectileBehavior(), new SpitItemBehavior());
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_2746 ON_COOLDOWN = class_2741.field_12522;

    public TrappedPresentBlock(class_1767 color, class_4970.class_2251 properties) {
        super(color, properties);
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)ON_COOLDOWN, (Comparable)Boolean.valueOf(false)));
    }

    public static void registerBehavior(class_1935 pItem, IFireItemBehavior pBehavior) {
        FIRE_BEHAVIORS.put(pItem.method_8389(), pBehavior);
    }

    public static IFireItemBehavior getPresentBehavior(class_1935 item) {
        return FIRE_BEHAVIORS.getOrDefault(item, DEFAULT);
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{FACING, ON_COOLDOWN});
    }

    @Nullable
    public class_2586 method_10123(class_2338 pPos, class_2680 pState) {
        return new TrappedPresentBlockTile(pPos, pState);
    }

    public boolean method_9592(class_2680 pState, class_1937 pLevel, class_2338 pPos, int pId, int pParam) {
        if (pId == 0 && ((Boolean)pState.method_11654((class_2769)ON_COOLDOWN)).booleanValue()) {
            if (pLevel.field_9236) {
                class_5819 random = pLevel.field_9229;
                double cx = (double)pPos.method_10263() + 0.5;
                double cy = (double)pPos.method_10264() + 0.5 + 0.4;
                double cz = (double)pPos.method_10260() + 0.5;
                for (int i = 0; i < 10; ++i) {
                    double speed = random.method_43058() * 0.15 + 0.015;
                    double py = cy + 0.02 + (random.method_43058() - 0.5) * 0.3;
                    double dx = random.method_43059() * 0.01;
                    double dy = speed + random.method_43059() * 0.01;
                    double dz = random.method_43059() * 0.01;
                    pLevel.method_8406((class_2394)class_2398.field_11204, cx, py, cz, dx, dy, dz);
                }
                ParticleUtil.spawnBreakParticles((class_265)PresentBlock.SHAPE_LID, (class_2338)pPos, (class_2680)pState, (class_1937)pLevel);
            }
            return true;
        }
        return super.method_9592(pState, pLevel, pPos, pId, pParam);
    }

    @Override
    public void method_9588(class_2680 state, class_3218 level, class_2338 pos, class_5819 random) {
        super.method_9588(state, level, pos, random);
        if (((Boolean)state.method_11654((class_2769)ON_COOLDOWN)).booleanValue()) {
            level.method_8501(pos, (class_2680)state.method_11657((class_2769)ON_COOLDOWN, (Comparable)Boolean.valueOf(false)));
        }
    }

    public class_2680 method_9598(class_2680 state, class_2470 rot) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rot.method_10503((class_2350)state.method_11654((class_2769)FACING)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirrorIn) {
        return state.method_26186(mirrorIn.method_10345((class_2350)state.method_11654((class_2769)FACING)));
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 block, class_2338 fromPos, boolean isMoving) {
        super.method_9612(state, world, pos, block, fromPos, isMoving);
        boolean isPowered = world.method_49803(pos);
        if (isPowered) {
            this.lightUp(null, state, pos, (class_1936)world, ILightable.FireSourceType.FIRE_CHANGE);
        }
    }

    public boolean isLitUp(class_2680 state, class_1922 level, class_2338 pos) {
        return (Boolean)state.method_11654((class_2769)PACKED) == false;
    }

    public boolean lightUp(@Nullable class_1297 player, class_2680 state, class_2338 pos, class_1936 world, ILightable.FireSourceType fireSourceType) {
        class_2586 class_25862;
        if (this.isLitUp(state, (class_1922)world, pos) && (class_25862 = world.method_8321(pos)) instanceof TrappedPresentBlockTile) {
            TrappedPresentBlockTile tile = (TrappedPresentBlockTile)class_25862;
            if (world instanceof class_3218) {
                class_3218 serverLevel = (class_3218)world;
                tile.detonate((class_1936)serverLevel, pos, state, null);
            }
            return true;
        }
        return false;
    }
}

