/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.block.IRotatable;
import net.mehvahdjukaar.moonlight.api.block.IWashable;
import net.mehvahdjukaar.moonlight.api.block.ItemDisplayTile;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.AbstractRopeBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.RopeBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BuntingBlockTile;
import net.mehvahdjukaar.supplementaries.common.items.BuntingItem;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class RopeBuntingBlock
extends AbstractRopeBlock
implements class_2343,
IRotatable,
IWashable {
    public static final class_2754<ModBlockProperties.Bunting> NORTH = ModBlockProperties.NORTH_BUNTING;
    public static final class_2754<ModBlockProperties.Bunting> SOUTH = ModBlockProperties.SOUTH_BUNTING;
    public static final class_2754<ModBlockProperties.Bunting> WEST = ModBlockProperties.WEST_BUNTING;
    public static final class_2754<ModBlockProperties.Bunting> EAST = ModBlockProperties.EAST_BUNTING;
    public static final class_2746 UP = class_2741.field_12519;
    public static final class_2746 DOWN = class_2741.field_12546;
    public static final Map<class_2350, class_2754<ModBlockProperties.Bunting>> HORIZONTAL_FACING_TO_PROPERTY_MAP = (Map)class_156.method_654((Object)Maps.newEnumMap(class_2350.class), directions -> {
        directions.put(class_2350.field_11043, NORTH);
        directions.put(class_2350.field_11034, EAST);
        directions.put(class_2350.field_11035, SOUTH);
        directions.put(class_2350.field_11039, WEST);
    });
    public final Map<class_2680, class_2680> buntingToRope = new Object2ObjectOpenHashMap();

    public RopeBuntingBlock(class_4970.class_2251 properties) {
        super(properties);
        UnmodifiableIterator unmodifiableIterator = this.field_10647.method_11662().iterator();
        while (unmodifiableIterator.hasNext()) {
            class_2680 state;
            class_2680 state1 = state = (class_2680)unmodifiableIterator.next();
            for (class_2350 dir : class_2350.class_2353.field_11062) {
                state1 = this.setConnection(dir, state1, this.hasConnection(dir, state1));
            }
            this.buntingToRope.put(state, state1);
        }
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{NORTH, SOUTH, WEST, EAST, UP, DOWN});
    }

    @Override
    protected Map<class_2680, class_265> makeShapes() {
        HashMap<class_2680, class_265> shapes = new HashMap<class_2680, class_265>();
        class_265 down = class_2248.method_9541((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)13.0, (double)10.0);
        class_265 up = class_2248.method_9541((double)6.0, (double)9.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
        class_265 north = class_2248.method_9541((double)6.0, (double)9.0, (double)0.0, (double)10.0, (double)13.0, (double)10.0);
        class_265 south = class_2248.method_9541((double)6.0, (double)9.0, (double)6.0, (double)10.0, (double)13.0, (double)16.0);
        class_265 west = class_2248.method_9541((double)0.0, (double)9.0, (double)6.0, (double)10.0, (double)13.0, (double)10.0);
        class_265 east = class_2248.method_9541((double)6.0, (double)9.0, (double)6.0, (double)16.0, (double)13.0, (double)10.0);
        class_265 knot = class_2248.method_9541((double)6.0, (double)9.0, (double)6.0, (double)10.0, (double)13.0, (double)10.0);
        class_265 northBunting = class_2248.method_9541((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)10.0, (double)8.0);
        class_265 southBunting = class_2248.method_9541((double)7.0, (double)0.0, (double)8.0, (double)9.0, (double)10.0, (double)16.0);
        class_265 westBunting = class_2248.method_9541((double)0.0, (double)0.0, (double)7.0, (double)8.0, (double)10.0, (double)9.0);
        class_265 eastBunting = class_2248.method_9541((double)8.0, (double)0.0, (double)7.0, (double)16.0, (double)10.0, (double)9.0);
        for (class_2680 state : this.field_10647.method_11662()) {
            ModBlockProperties.Bunting e;
            ModBlockProperties.Bunting w;
            ModBlockProperties.Bunting s;
            ModBlockProperties.Bunting n;
            if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) continue;
            class_265 v = class_259.method_1073();
            if (((Boolean)state.method_11654((class_2769)KNOT)).booleanValue()) {
                v = class_259.method_17786((class_265)knot, (class_265[])new class_265[0]);
            }
            if (((Boolean)state.method_11654((class_2769)DOWN)).booleanValue()) {
                v = class_259.method_1084((class_265)v, (class_265)down);
            }
            if (((Boolean)state.method_11654((class_2769)UP)).booleanValue()) {
                v = class_259.method_1084((class_265)v, (class_265)up);
            }
            if ((n = (ModBlockProperties.Bunting)((Object)state.method_11654(NORTH))).isConnected()) {
                v = class_259.method_1084((class_265)v, (class_265)north);
            }
            if (n.hasBunting()) {
                v = class_259.method_1084((class_265)v, (class_265)northBunting);
            }
            if ((s = (ModBlockProperties.Bunting)((Object)state.method_11654(SOUTH))).isConnected()) {
                v = class_259.method_1084((class_265)v, (class_265)south);
            }
            if (s.hasBunting()) {
                v = class_259.method_1084((class_265)v, (class_265)southBunting);
            }
            if ((w = (ModBlockProperties.Bunting)((Object)state.method_11654(WEST))).isConnected()) {
                v = class_259.method_1084((class_265)v, (class_265)west);
            }
            if (w.hasBunting()) {
                v = class_259.method_1084((class_265)v, (class_265)westBunting);
            }
            if ((e = (ModBlockProperties.Bunting)((Object)state.method_11654(EAST))).isConnected()) {
                v = class_259.method_1084((class_265)v, (class_265)east);
            }
            if (e.hasBunting()) {
                v = class_259.method_1084((class_265)v, (class_265)eastBunting);
            }
            v = v.method_1097();
            boolean flag = true;
            for (class_265 existing : shapes.values()) {
                if (!existing.equals(v)) continue;
                shapes.put(state, existing);
                flag = false;
                break;
            }
            if (!flag) continue;
            shapes.put(state, v);
        }
        return new Object2ObjectOpenHashMap(shapes);
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean isMoving) {
        if (state.method_26204() != newState.method_26204()) {
            class_2586 class_25862 = world.method_8321(pos);
            if (class_25862 instanceof ItemDisplayTile) {
                ItemDisplayTile tile = (ItemDisplayTile)class_25862;
                class_1264.method_5451((class_1937)world, (class_2338)pos, (class_1263)tile);
            }
            super.method_9536(state, world, pos, newState, isMoving);
        }
    }

    @Override
    public boolean hasConnection(class_2350 dir, class_2680 state) {
        if (dir == class_2350.field_11033) {
            return (Boolean)state.method_11654((class_2769)DOWN);
        }
        if (dir == class_2350.field_11036) {
            return (Boolean)state.method_11654((class_2769)UP);
        }
        return ((ModBlockProperties.Bunting)((Object)state.method_11654((class_2769)HORIZONTAL_FACING_TO_PROPERTY_MAP.get(dir)))).isConnected();
    }

    @Override
    public class_2680 setConnection(class_2350 dir, class_2680 state, boolean value) {
        if (dir == class_2350.field_11033) {
            return (class_2680)state.method_11657((class_2769)DOWN, (Comparable)Boolean.valueOf(value));
        }
        if (dir == class_2350.field_11036) {
            return (class_2680)state.method_11657((class_2769)UP, (Comparable)Boolean.valueOf(value));
        }
        return (class_2680)state.method_11657((class_2769)HORIZONTAL_FACING_TO_PROPERTY_MAP.get(dir), (Comparable)((Object)(value ? ModBlockProperties.Bunting.ROPE : ModBlockProperties.Bunting.NONE)));
    }

    public Optional<class_2680> getRotatedState(class_2680 state, class_1936 world, class_2338 pos, class_2470 rotation, class_2350 axis, @Nullable class_243 hit) {
        return Optional.of(state);
    }

    public Optional<class_2350> rotateOverAxis(class_2680 state, class_1936 level, class_2338 pos, class_2470 rotation, class_2350 axis, @Nullable class_243 hit) {
        class_2586 class_25862;
        if (axis.method_10166() == class_2350.class_2351.field_11052 && (class_25862 = level.method_8321(pos)) instanceof BuntingBlockTile) {
            BuntingBlockTile tile = (BuntingBlockTile)class_25862;
            HashMap<class_2350, class_1799> newMap = new HashMap<class_2350, class_1799>();
            for (class_2350 dir2 : class_2350.class_2353.field_11062) {
                class_1799 stack2 = tile.method_5438(dir2.method_10161());
                if (stack2.method_7960()) continue;
                class_2350 newDir = rotation.method_10503(dir2);
                if (RopeBuntingBlock.canSupportBunting(state, newDir.method_10161())) {
                    newMap.put(newDir, stack2);
                    continue;
                }
                return Optional.empty();
            }
            if (!newMap.isEmpty()) {
                tile.method_5448();
                newMap.forEach((dir, stack) -> tile.method_5447(dir.method_10161(), (class_1799)stack));
                return Optional.of(axis);
            }
        }
        return Optional.empty();
    }

    @Override
    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return super.method_9598(state, rotation);
    }

    @Override
    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return super.method_9569(state, mirror);
    }

    @Override
    public class_265 method_9549(class_2680 state, class_1922 worldIn, class_2338 pos, class_3726 context) {
        return super.method_9549(this.buntingToRope.get(state), worldIn, pos, context);
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new BuntingBlockTile(pos, state);
    }

    @Override
    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 handIn, class_3965 hit) {
        Optional<class_2350> closest;
        BuntingBlockTile tile;
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof BuntingBlockTile && (tile = (BuntingBlockTile)class_25862).isAccessibleBy(player) && (closest = RopeBuntingBlock.findClosestConnection(state, pos, hit.method_17784())).isPresent()) {
            return tile.interact(player, handIn, closest.get().method_10161());
        }
        return class_1269.field_5811;
    }

    public class_1799 getCloneItemStack(class_2680 state, class_239 target, class_1922 world, class_2338 pos, class_1657 player) {
        Optional<class_2350> closest = RopeBuntingBlock.findClosestConnection(state, pos, target.method_17784());
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof BuntingBlockTile) {
            class_1799 held;
            BuntingBlockTile tile = (BuntingBlockTile)class_25862;
            if (closest.isPresent() && !(held = tile.method_5438(closest.get().method_10161())).method_7960()) {
                return held.method_7972();
            }
        }
        return this.method_9574(world, pos, state);
    }

    public class_1799 method_9574(class_1922 level, class_2338 pos, class_2680 state) {
        return ModRegistry.ROPE_ITEM.get().method_7854();
    }

    private static Optional<class_2350> findClosestConnection(class_2680 state, class_2338 pos, class_243 hit) {
        Vector3f hitPos = hit.method_1023((double)pos.method_10263() + 0.5, 0.0, (double)pos.method_10260() + 0.5).method_46409();
        List<class_2350> availableDir = class_2350.class_2353.field_11062.method_29716().filter(dir -> ((AbstractRopeBlock)state.method_26204()).hasConnection((class_2350)dir, state)).toList();
        return availableDir.stream().min((a, b) -> {
            Vector3f v1 = a.method_23955();
            Vector3f v2 = b.method_23955();
            float d1 = v1.distanceSquared((Vector3fc)hitPos);
            float d2 = v2.distanceSquared((Vector3fc)hitPos);
            return Float.compare(d1, d2);
        });
    }

    @Override
    public class_2680 method_9559(class_2680 stateIn, class_2350 facing, class_2680 facingState, class_1936 level, class_2338 pos, class_2338 facingPos) {
        class_2586 class_25862;
        class_2680 newState = super.method_9559(stateIn, facing, facingState, level, pos, facingPos);
        if (facing.method_10166().method_10179() && this.hasConnection(facing, stateIn) && (class_25862 = level.method_8321(pos)) instanceof BuntingBlockTile) {
            BuntingBlockTile tile = (BuntingBlockTile)class_25862;
            int index = facing.method_10161();
            class_1799 item = tile.method_5438(index);
            if (!item.method_7960()) {
                if (!RopeBuntingBlock.canSupportBunting(newState, index)) {
                    if (level instanceof class_1937) {
                        class_1937 l = (class_1937)level;
                        this.popItem(l, pos, item, facing);
                    }
                    tile.method_5447(index, class_1799.field_8037);
                    newState = (class_2680)newState.method_11657((class_2769)HORIZONTAL_FACING_TO_PROPERTY_MAP.get(facing), (Comparable)((Object)ModBlockProperties.Bunting.NONE));
                } else {
                    newState = (class_2680)newState.method_11657((class_2769)HORIZONTAL_FACING_TO_PROPERTY_MAP.get(facing), (Comparable)((Object)ModBlockProperties.Bunting.BUNTING));
                }
            }
            if (tile.method_5442()) {
                newState = RopeBuntingBlock.toRope(newState);
            }
        }
        return newState;
    }

    public void popItem(class_1937 level, class_2338 pos, class_1799 stack, class_2350 dir) {
        if (!level.field_9236 && !stack.method_7960() && level.method_8450().method_8355(class_1928.field_19392)) {
            double h = (double)class_1299.field_6052.method_17686() / 2.0 + 0.25;
            Vector3f step = dir.method_23955().mul(0.25f);
            double x = (double)(step.x + (float)pos.method_10263()) + 0.5;
            double y = (double)(step.y + (float)pos.method_10264()) + 0.5 - h;
            double z = (double)(step.z + (float)pos.method_10260()) + 0.5;
            class_1542 itemEntity = new class_1542(level, x, y, z, stack.method_7972());
            itemEntity.method_6988();
            level.method_8649((class_1297)itemEntity);
        }
    }

    public static boolean canSupportBunting(class_2680 state, int index) {
        class_2350 dir = class_2350.method_10139((int)index);
        return ((ModBlockProperties.Bunting)((Object)state.method_11654((class_2769)HORIZONTAL_FACING_TO_PROPERTY_MAP.get(dir)))).isConnected();
    }

    @Nullable
    public static class_2680 fromRope(class_2680 state, class_3965 hit) {
        class_2680 s = RopeBuntingBlock.fromRope(state);
        Optional<class_2350> closest = RopeBuntingBlock.findClosestConnection(state, hit.method_17777(), hit.method_17784());
        return closest.map(direction -> (class_2680)s.method_11657((class_2769)HORIZONTAL_FACING_TO_PROPERTY_MAP.get(direction), (Comparable)((Object)ModBlockProperties.Bunting.BUNTING))).orElse(null);
    }

    public static class_2680 fromRope(class_2680 state) {
        RopeBuntingBlock block = ModRegistry.BUNTING_BLOCK.get();
        class_2680 s = block.method_34725(state);
        for (class_2350 dir : class_2350.class_2353.field_11062) {
            s = block.setConnection(dir, s, ((RopeBlock)state.method_26204()).hasConnection(dir, state));
        }
        return s;
    }

    public static class_2680 toRope(class_2680 state) {
        RopeBlock block = ModRegistry.ROPE.get();
        class_2680 s = block.method_34725(state);
        for (class_2350 dir : class_2350.class_2353.field_11062) {
            s = block.setConnection(dir, s, ((RopeBuntingBlock)state.method_26204()).hasConnection(dir, state));
        }
        return s;
    }

    public boolean tryWash(class_1937 level, class_2338 pos, class_2680 state, class_243 hitVec) {
        Optional<class_2350> closest = RopeBuntingBlock.findClosestConnection(state, pos, hitVec);
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof BuntingBlockTile) {
            class_1799 held;
            BuntingBlockTile tile = (BuntingBlockTile)class_25862;
            if (closest.isPresent() && !(held = tile.method_5438(closest.get().method_10161())).method_7960() && BuntingItem.getColor(held) != class_1767.field_7952) {
                BuntingItem.setColor(held, class_1767.field_7952);
                tile.method_5447(closest.get().method_10161(), held);
                tile.method_5431();
                level.method_8413(pos, state, state, 3);
                return true;
            }
        }
        return false;
    }
}

