/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.chirpycricket.wildlife.registry;

import com.yahoo.chirpycricket.wildlife.entity.MediumAquaticWildlifeEntity;
import com.yahoo.chirpycricket.wildlife.entity.WildlifeEntity;
import com.yahoo.chirpycricket.wildlife.entity.entities.AquaticFishEntity;
import com.yahoo.chirpycricket.wildlife.entity.entities.AquaticInsectEntity;
import com.yahoo.chirpycricket.wildlife.entity.entities.AquaticStationaryEntity;
import com.yahoo.chirpycricket.wildlife.entity.entities.BucketableAquaticFishEntity;
import com.yahoo.chirpycricket.wildlife.entity.entities.FlyingBirdEntity;
import com.yahoo.chirpycricket.wildlife.entity.entities.FlyingInsectEntity;
import com.yahoo.chirpycricket.wildlife.entity.entities.GroundInsectEntity;
import com.yahoo.chirpycricket.wildlife.entity.entities.SmallTerrestrialEntity;
import com.yahoo.chirpycricket.wildlife.entity.entities.TerrestrialEntity;
import com.yahoo.chirpycricket.wildlife.items.EntityItem;
import com.yahoo.chirpycricket.wildlife.registry.SpawnSettings;
import java.util.HashMap;
import net.fabricmc.fabric.api.item.v1.EquipmentSlotProvider;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricEntityTypeBuilder;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1311;
import net.minecraft.class_1785;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_4048;
import net.minecraft.class_4176;
import net.minecraft.class_5132;
import net.minecraft.class_5321;
import net.minecraft.class_7706;
import net.minecraft.class_7923;

public class Entities {
    public static HashMap<EntityKey, EntityMapEntry> entityMap = new HashMap();
    public static HashMap<EntityKey, Class> classesForSettings = new HashMap();
    public static final EquipmentSlotProvider headSlot = new EquipmentSlotProvider(){

        public class_1304 getPreferredEquipmentSlot(class_1799 stack) {
            return class_1304.field_6169;
        }
    };
    public static final FabricItemSettings itemSettings = new FabricItemSettings().equipmentSlot(headSlot).maxCount(1);
    public static final FabricItemSettings bucketItemSettings = new FabricItemSettings().maxCount(1);
    public static final class_1792.class_1793 eggItemSettings = new class_1792.class_1793();

    public static void init() {
        entityMap.put(EntityKey.HORSESHOE_CRAB, new EntityMapEntry(EntityKey.HORSESHOE_CRAB, AquaticInsectEntity.HorseshoeCrabEntity.class, AquaticInsectEntity.HorseshoeCrabEntity::new, "geo/horseshoecrab.geo.json", "animations/horseshoecrab.animation.json", "textures/model/entity/small_aquatic.png", 0.25f, class_4048.method_18385((float)0.5f, (float)0.3125f), "horseshoecrab", -1, -1, false, false, false));
        entityMap.put(EntityKey.SANDDOLLAR, new EntityMapEntry(EntityKey.SANDDOLLAR, AquaticStationaryEntity.SanddollarEntity.class, AquaticStationaryEntity.SanddollarEntity::new, "geo/sanddollar.geo.json", "animations/none.animation.json", "textures/model/entity/small_aquatic.png", 0.25f, class_4048.method_18385((float)0.5f, (float)0.3125f), "sanddollar", -1, -1, false, false, false));
        entityMap.put(EntityKey.STARFISH, new EntityMapEntry(EntityKey.STARFISH, AquaticStationaryEntity.StarfishEntity.class, AquaticStationaryEntity.StarfishEntity::new, "geo/starfish.geo.json", "animations/starfish.animation.json", "textures/model/entity/small_aquatic.png", 0.25f, class_4048.method_18385((float)0.5f, (float)0.3125f), "starfish", -1, -1, false, false, false));
        entityMap.put(EntityKey.SEAURCHIN, new EntityMapEntry(EntityKey.SEAURCHIN, AquaticStationaryEntity.SeaurchinEntity.class, AquaticStationaryEntity.SeaurchinEntity::new, "geo/seaurchin.geo.json", "animations/none.animation.json", "textures/model/entity/small_aquatic.png", 0.25f, class_4048.method_18385((float)0.5f, (float)0.3125f), "seaurchin", -1, -1, false, false, false));
        entityMap.put(EntityKey.CLAM, new EntityMapEntry(EntityKey.CLAM, AquaticStationaryEntity.ClamEntity.class, AquaticStationaryEntity.ClamEntity::new, "geo/clam.geo.json", "animations/clam.animation.json", "textures/model/entity/small_aquatic.png", 0.25f, class_4048.method_18385((float)0.5f, (float)0.3125f), "clam", -1, -1, false, false, false, true));
        entityMap.put(EntityKey.HAMMERHEAD_SHARK, new EntityMapEntry(EntityKey.HAMMERHEAD_SHARK, AquaticFishEntity.HammerheadSharkEntity.class, AquaticFishEntity.HammerheadSharkEntity::new, "geo/hammerhead_shark.geo.json", "animations/hammerhead_shark.animation.json", "textures/model/entity/stingray.png", 0.35f, class_4048.method_18385((float)1.25f, (float)0.5f), "hammerhead_shark", 0x4D4A4A, 0x888888, false, false, false));
        entityMap.put(EntityKey.MANTARAY, new EntityMapEntry(EntityKey.MANTARAY, AquaticFishEntity.MantarayEntity.class, AquaticFishEntity.MantarayEntity::new, "geo/mantaray.geo.json", "animations/stingray.animation.json", "textures/model/entity/stingray.png", 0.35f, class_4048.method_18385((float)1.25f, (float)0.5f), "mantaray", 0x4D4A4A, 0xFFFFFF, false, false, false, true));
        entityMap.put(EntityKey.STINGRAY, new EntityMapEntry(EntityKey.STINGRAY, AquaticFishEntity.StingrayEntity.class, AquaticFishEntity.StingrayEntity::new, "geo/stingray.geo.json", "animations/stingray.animation.json", "textures/model/entity/stingray.png", 0.35f, class_4048.method_18385((float)1.0f, (float)0.5f), "stingray", 0x333437, 0xFFFFFF, false, false, false, true));
        entityMap.put(EntityKey.JELLYFISH, new EntityMapEntry(EntityKey.JELLYFISH, BucketableAquaticFishEntity.JellyfishEntity.class, BucketableAquaticFishEntity.JellyfishEntity::new, "geo/jellyfish.geo.json", "animations/jellyfish.animation.json", "textures/model/entity/jellyfish1.png", 0.35f, class_4048.method_18385((float)0.625f, (float)0.5f), "jellyfish", 5101808, 0xFFFFFF, false, false, true));
        entityMap.put(EntityKey.GLOW_JELLYFISH, new EntityMapEntry(EntityKey.GLOW_JELLYFISH, BucketableAquaticFishEntity.JellyfishEntity.class, BucketableAquaticFishEntity.JellyfishEntity::new, "geo/jellyfish.geo.json", "animations/jellyfish.animation.json", "textures/model/entity/jellyfish1.png", 0.35f, class_4048.method_18385((float)0.625f, (float)0.5f), "glow_jellyfish", 5101808, 0xFFFFFF, false, true, true));
        entityMap.put(EntityKey.SEAHORSE, new EntityMapEntry(EntityKey.SEAHORSE, BucketableAquaticFishEntity.SeahorseEntity.class, BucketableAquaticFishEntity.SeahorseEntity::new, "geo/seahorse.geo.json", "animations/seahorse.animation.json", "textures/model/entity/small_aquatic.png", 0.35f, class_4048.method_18385((float)0.375f, (float)0.5f), "seahorse", 15386682, 0xFFFFFF, false, false, false));
        entityMap.put(EntityKey.ANGLERFISH, new EntityMapEntry(EntityKey.ANGLERFISH, BucketableAquaticFishEntity.AnglerfishEntity.class, BucketableAquaticFishEntity.AnglerfishEntity::new, "geo/anglerfish.geo.json", "animations/fish.animation.json", "textures/model/entity/fish.png", 0.35f, class_4048.method_18385((float)0.75f, (float)0.5f), "anglerfish", 0x202020, 0xECECC5, false, true, false, true));
        entityMap.put(EntityKey.ALLIGATOR, new EntityMapEntry(EntityKey.ALLIGATOR, TerrestrialEntity.AlligatorEntity.class, TerrestrialEntity.AlligatorEntity::new, "geo/alligator.geo.json", "animations/alligator.animation.json", "textures/model/entity/alligator.png", 0.35f, class_4048.method_18385((float)1.75f, (float)0.625f), "alligator", 2631974, 12895920, false, false, false));
        entityMap.put(EntityKey.KOI, new EntityMapEntry(EntityKey.KOI, BucketableAquaticFishEntity.KoiEntity.class, BucketableAquaticFishEntity.KoiEntity::new, "geo/koi.geo.json", "animations/fish.animation.json", "textures/model/entity/koi1.png", 0.35f, class_4048.method_18385((float)0.75f, (float)0.5f), "koi", 0xEAEAEA, 12930895, false, false, false, true));
        entityMap.put(EntityKey.RAINBOW_TROUT, new EntityMapEntry(EntityKey.RAINBOW_TROUT, BucketableAquaticFishEntity.RainbowTroutEntity.class, BucketableAquaticFishEntity.RainbowTroutEntity::new, "geo/rainbow_trout.geo.json", "animations/fish.animation.json", "textures/model/entity/fish.png", 0.35f, class_4048.method_18385((float)0.75f, (float)0.5f), "rainbow_trout", 4222272, 11987437, false, false, false, true));
        entityMap.put(EntityKey.CATFISH, new EntityMapEntry(EntityKey.CATFISH, BucketableAquaticFishEntity.CatfishEntity.class, BucketableAquaticFishEntity.CatfishEntity::new, "geo/catfish.geo.json", "animations/fish.animation.json", "textures/model/entity/fish.png", 0.35f, class_4048.method_18385((float)0.75f, (float)0.5f), "catfish", 2367775, 13808781, false, false, false, true));
        entityMap.put(EntityKey.PRAWN, new EntityMapEntry(EntityKey.PRAWN, BucketableAquaticFishEntity.PrawnEntity.class, BucketableAquaticFishEntity.PrawnEntity::new, "geo/prawn.geo.json", "animations/shrimp.animation.json", "textures/model/entity/small_aquatic.png", 0.35f, class_4048.method_18385((float)0.5f, (float)0.5f), "prawn", 12958883, 11895694, false, false, false, true));
        entityMap.put(EntityKey.SHRIMP, new EntityMapEntry(EntityKey.SHRIMP, BucketableAquaticFishEntity.ShrimpEntity.class, BucketableAquaticFishEntity.ShrimpEntity::new, "geo/shrimp.geo.json", "animations/shrimp.animation.json", "textures/model/entity/small_aquatic.png", 0.35f, class_4048.method_18385((float)0.5f, (float)0.5f), "shrimp", 16625086, 16649279, false, false, false, true));
        entityMap.put(EntityKey.BETTAFISH, new EntityMapEntry(EntityKey.BETTAFISH, BucketableAquaticFishEntity.BettafishEntity.class, BucketableAquaticFishEntity.BettafishEntity::new, "geo/bettafish.geo.json", "animations/fish.animation.json", "textures/model/entity/fish.png", 0.35f, class_4048.method_18385((float)0.5f, (float)0.5f), "bettafish", 138495, 378879, false, false, false, true));
        entityMap.put(EntityKey.GOLDFISH, new EntityMapEntry(EntityKey.GOLDFISH, BucketableAquaticFishEntity.GoldFishEntity.class, BucketableAquaticFishEntity.GoldFishEntity::new, "geo/goldfish.geo.json", "animations/fish.animation.json", "textures/model/entity/fish.png", 0.35f, class_4048.method_18385((float)0.5f, (float)0.5f), "goldfish", 16743187, 16762262, false, false, false, true));
        entityMap.put(EntityKey.BLUEGILL, new EntityMapEntry(EntityKey.BLUEGILL, BucketableAquaticFishEntity.BluegillEntity.class, BucketableAquaticFishEntity.BluegillEntity::new, "geo/bluegill.geo.json", "animations/fish.animation.json", "textures/model/entity/fish.png", 0.35f, class_4048.method_18385((float)0.5f, (float)0.5f), "bluegill", 9013603, 3094054, false, false, false, true));
        entityMap.put(EntityKey.KING_SNAKE, new EntityMapEntry(EntityKey.KING_SNAKE, SmallTerrestrialEntity.KingSnakeEntity.class, SmallTerrestrialEntity.KingSnakeEntity::new, "geo/king_snake.geo.json", "animations/snake.animation.json", "textures/model/entity/small_snakes.png", 0.25f, class_4048.method_18385((float)0.625f, (float)0.5f), "king_snake", -1, -1, true, false, false));
        entityMap.put(EntityKey.PYTHON, new EntityMapEntry(EntityKey.PYTHON, SmallTerrestrialEntity.PythonEntity.class, SmallTerrestrialEntity.PythonEntity::new, "geo/python.geo.json", "animations/large_snake.animation.json", "textures/model/entity/small_snakes.png", 0.25f, class_4048.method_18385((float)0.625f, (float)0.75f), "python", -1, -1, true, false, false));
        entityMap.put(EntityKey.MILK_SNAKE, new EntityMapEntry(EntityKey.MILK_SNAKE, SmallTerrestrialEntity.MilkSnakeEntity.class, SmallTerrestrialEntity.MilkSnakeEntity::new, "geo/milk_snake.geo.json", "animations/snake.animation.json", "textures/model/entity/small_snakes.png", 0.25f, class_4048.method_18385((float)0.625f, (float)0.5f), "milk_snake", -1, -1, true, false, false));
        entityMap.put(EntityKey.GRASS_SNAKE, new EntityMapEntry(EntityKey.GRASS_SNAKE, SmallTerrestrialEntity.GrassSnakeEntity.class, SmallTerrestrialEntity.GrassSnakeEntity::new, "geo/grass_snake.geo.json", "animations/snake.animation.json", "textures/model/entity/small_snakes.png", 0.25f, class_4048.method_18385((float)0.625f, (float)0.5f), "grass_snake", -1, -1, true, false, false));
        entityMap.put(EntityKey.GECKO, new EntityMapEntry(EntityKey.GECKO, SmallTerrestrialEntity.GeckoEntity.class, SmallTerrestrialEntity.GeckoEntity::new, "geo/gecko.geo.json", "animations/gecko.animation.json", "textures/model/entity/small_terrestrial.png", 0.25f, class_4048.method_18385((float)0.3125f, (float)0.3125f), "gecko", -1, -1, true, false, false));
        entityMap.put(EntityKey.CHAMELEON, new EntityMapEntry(EntityKey.CHAMELEON, SmallTerrestrialEntity.ChameleonEntity.class, SmallTerrestrialEntity.ChameleonEntity::new, "geo/chameleon.geo.json", "animations/smallanimal.animation.json", "textures/model/entity/small_terrestrial.png", 0.25f, class_4048.method_18385((float)0.3125f, (float)0.3125f), "chameleon", -1, -1, true, false, false));
        entityMap.put(EntityKey.HAMSTER, new EntityMapEntry(EntityKey.HAMSTER, SmallTerrestrialEntity.HamsterEntity.class, SmallTerrestrialEntity.HamsterEntity::new, "geo/hamster.geo.json", "animations/smallanimal.animation.json", "textures/model/entity/small_terrestrial.png", 0.15f, class_4048.method_18385((float)0.3125f, (float)0.3125f), "hamster", -1, -1, true, false, false));
        entityMap.put(EntityKey.FERRET, new EntityMapEntry(EntityKey.FERRET, SmallTerrestrialEntity.FerretEntity.class, SmallTerrestrialEntity.FerretEntity::new, "geo/ferret.geo.json", "animations/smallanimal.animation.json", "textures/model/entity/small_terrestrial.png", 0.25f, class_4048.method_18385((float)0.5f, (float)0.3125f), "ferret", -1, -1, true, false, false));
        entityMap.put(EntityKey.HEDGEHOG, new EntityMapEntry(EntityKey.HEDGEHOG, SmallTerrestrialEntity.HedgehogEntity.class, SmallTerrestrialEntity.HedgehogEntity::new, "geo/hedgehog.geo.json", "animations/smallanimal.animation.json", "textures/model/entity/small_terrestrial.png", 0.25f, class_4048.method_18385((float)0.3125f, (float)0.3125f), "hedgehog", -1, -1, true, false, false));
        entityMap.put(EntityKey.HERMITCRAB, new EntityMapEntry(EntityKey.HERMITCRAB, AquaticInsectEntity.HermitcrabEntity.class, AquaticInsectEntity.HermitcrabEntity::new, "geo/hermitcrab.geo.json", "animations/hermitcrab.animation.json", "textures/model/entity/small_aquatic.png", 0.25f, class_4048.method_18385((float)0.3125f, (float)0.3125f), "hermitcrab", -1, -1, false, false, false));
        entityMap.put(EntityKey.CRAB, new EntityMapEntry(EntityKey.CRAB, AquaticInsectEntity.CrabEntity.class, AquaticInsectEntity.CrabEntity::new, "geo/crab.geo.json", "animations/crab.animation.json", "textures/model/entity/small_aquatic.png", 0.25f, class_4048.method_18385((float)0.5f, (float)0.3125f), "crab", -1, -1, false, false, false));
        entityMap.put(EntityKey.IGUANA, new EntityMapEntry(EntityKey.IGUANA, TerrestrialEntity.IguanaEntity.class, TerrestrialEntity.IguanaEntity::new, "geo/iguana.geo.json", "animations/animal.animation.json", "textures/model/entity/iguana.png", 0.35f, class_4048.method_18385((float)0.625f, (float)0.625f), "iguana", 8162897, 9927977, true, false, false));
        entityMap.put(EntityKey.RHINOBEETLE, new EntityMapEntry(EntityKey.RHINOBEETLE, GroundInsectEntity.RhinoBeetleEntity.class, GroundInsectEntity.RhinoBeetleEntity::new, "geo/rhino_beetle.geo.json", "animations/insect.animation.json", "textures/model/entity/bugs.png", 0.25f, class_4048.method_18385((float)0.5f, (float)0.25f), "rhino_beetle", -1, -1, false, false, false));
        entityMap.put(EntityKey.STAGHORNBEETLE, new EntityMapEntry(EntityKey.STAGHORNBEETLE, GroundInsectEntity.StaghornBeetleEntity.class, GroundInsectEntity.StaghornBeetleEntity::new, "geo/staghorn_beetle.geo.json", "animations/insect.animation.json", "textures/model/entity/bugs.png", 0.25f, class_4048.method_18385((float)0.5f, (float)0.25f), "staghorn_beetle", -1, -1, false, false, false));
        entityMap.put(EntityKey.JUNEBEETLE, new EntityMapEntry(EntityKey.JUNEBEETLE, GroundInsectEntity.JuneBeetleEntity.class, GroundInsectEntity.JuneBeetleEntity::new, "geo/june_beetle.geo.json", "animations/insect.animation.json", "textures/model/entity/bugs.png", 0.25f, class_4048.method_18385((float)0.5f, (float)0.25f), "june_beetle", -1, -1, false, false, false));
        entityMap.put(EntityKey.MONKEY, new EntityMapEntry(EntityKey.MONKEY, TerrestrialEntity.MonkeyEntity.class, TerrestrialEntity.MonkeyEntity::new, "geo/monkey.geo.json", "animations/animal.animation.json", "textures/model/entity/monkey.png", 0.35f, class_4048.method_18385((float)0.75f, (float)1.0f), "monkey", 7684134, 11702390, true, false, false));
        entityMap.put(EntityKey.BOAR, new EntityMapEntry(EntityKey.BOAR, TerrestrialEntity.BoarEntity.class, TerrestrialEntity.BoarEntity::new, "geo/boar.geo.json", "animations/animal.animation.json", "textures/model/entity/boar.png", 0.25f, class_4048.method_18385((float)0.9375f, (float)1.25f), "boar", 6504739, 2430731, true, false, false));
        entityMap.put(EntityKey.DEER, new EntityMapEntry(EntityKey.DEER, TerrestrialEntity.DeerEntity.class, TerrestrialEntity.DeerEntity::new, "geo/deer.geo.json", "animations/animal.animation.json", "textures/model/entity/deer.png", 0.25f, class_4048.method_18385((float)0.75f, (float)1.4375f), "deer", 11702352, 0xFFFFFF, true, false, false));
        entityMap.put(EntityKey.CAPYBARA, new EntityMapEntry(EntityKey.CAPYBARA, TerrestrialEntity.CapybaraEntity.class, TerrestrialEntity.CapybaraEntity::new, "geo/capybara.geo.json", "animations/animal.animation.json", "textures/model/entity/capybara.png", 0.25f, class_4048.method_18385((float)0.625f, (float)0.9375f), "capybara", 11375453, 11375453, true, false, false));
        entityMap.put(EntityKey.POSSUM, new EntityMapEntry(EntityKey.POSSUM, TerrestrialEntity.PossumEntity.class, TerrestrialEntity.PossumEntity::new, "geo/possum.geo.json", "animations/animal.animation.json", "textures/model/entity/possum.png", 0.25f, class_4048.method_18385((float)0.625f, (float)0.4375f), "possum", 0xBDBDBD, 0xF2AAAA, true, false, false));
        entityMap.put(EntityKey.ANTEATER, new EntityMapEntry(EntityKey.ANTEATER, TerrestrialEntity.AntEaterEntity.class, TerrestrialEntity.AntEaterEntity::new, "geo/anteater.geo.json", "animations/animal.animation.json", "textures/model/entity/anteater.png", 0.35f, class_4048.method_18385((float)0.625f, (float)0.5f), "anteater", 4076332, 4076332, true, false, false));
        entityMap.put(EntityKey.ARMADILLO, new EntityMapEntry(EntityKey.ARMADILLO, TerrestrialEntity.ArmadilloEntity.class, TerrestrialEntity.ArmadilloEntity::new, "geo/armadillo.geo.json", "animations/armadillo.animation.json", "textures/model/entity/armadillo.png", 0.35f, class_4048.method_18385((float)0.625f, (float)0.5f), "armadillo", 10391641, 10391641, true, false, false));
        entityMap.put(EntityKey.BEAVER, new EntityMapEntry(EntityKey.BEAVER, TerrestrialEntity.BeaverEntity.class, TerrestrialEntity.BeaverEntity::new, "geo/beaver.geo.json", "animations/animal.animation.json", "textures/model/entity/beaver.png", 0.45f, class_4048.method_18385((float)0.625f, (float)0.5f), "beaver", 4534050, 4534050, true, false, false));
        entityMap.put(EntityKey.PORCUPINE, new EntityMapEntry(EntityKey.PORCUPINE, TerrestrialEntity.PorcupineEntity.class, TerrestrialEntity.PorcupineEntity::new, "geo/porcupine.geo.json", "animations/animal.animation.json", "textures/model/entity/porcupine.png", 0.45f, class_4048.method_18385((float)0.625f, (float)0.75f), "porcupine", 3090982, 0xFFFFFF, true, false, false));
        entityMap.put(EntityKey.BADGER, new EntityMapEntry(EntityKey.BADGER, TerrestrialEntity.BadgerEntity.class, TerrestrialEntity.BadgerEntity::new, "geo/badger.geo.json", "animations/animal.animation.json", "textures/model/entity/badger.png", 0.45f, class_4048.method_18385((float)0.625f, (float)0.625f), "badger", 6314579, 6314579, true, false, false));
        entityMap.put(EntityKey.SWALLOW, new EntityMapEntry(EntityKey.SWALLOW, FlyingBirdEntity.SwallowEntity.class, FlyingBirdEntity.SwallowEntity::new, "geo/swallow.geo.json", "animations/small_bird.animation.json", "textures/model/entity/birds.png", 0.1f, class_4048.method_18385((float)0.4375f, (float)0.375f), "swallow", -1, -1, true, false, false));
        entityMap.put(EntityKey.PHOEBE, new EntityMapEntry(EntityKey.PHOEBE, FlyingBirdEntity.PhoebeEntity.class, FlyingBirdEntity.PhoebeEntity::new, "geo/phoebe.geo.json", "animations/small_bird.animation.json", "textures/model/entity/birds.png", 0.1f, class_4048.method_18385((float)0.4375f, (float)0.375f), "phoebe", -1, -1, true, false, false));
        entityMap.put(EntityKey.GOLDFINCH, new EntityMapEntry(EntityKey.GOLDFINCH, FlyingBirdEntity.GoldfinchEntity.class, FlyingBirdEntity.GoldfinchEntity::new, "geo/goldfinch.geo.json", "animations/small_bird.animation.json", "textures/model/entity/birds.png", 0.1f, class_4048.method_18385((float)0.4375f, (float)0.375f), "goldfinch", -1, -1, true, false, false));
        entityMap.put(EntityKey.BLUEBIRD, new EntityMapEntry(EntityKey.BLUEBIRD, FlyingBirdEntity.BluebirdEntity.class, FlyingBirdEntity.BluebirdEntity::new, "geo/bluebird.geo.json", "animations/small_bird.animation.json", "textures/model/entity/birds.png", 0.1f, class_4048.method_18385((float)0.4375f, (float)0.375f), "bluebird", -1, -1, true, false, false));
        entityMap.put(EntityKey.ORIOLE, new EntityMapEntry(EntityKey.ORIOLE, FlyingBirdEntity.OrioleEntity.class, FlyingBirdEntity.OrioleEntity::new, "geo/oriole.geo.json", "animations/small_bird.animation.json", "textures/model/entity/birds.png", 0.1f, class_4048.method_18385((float)0.4375f, (float)0.375f), "oriole", -1, -1, true, false, false));
        entityMap.put(EntityKey.MEADOWLARK, new EntityMapEntry(EntityKey.MEADOWLARK, FlyingBirdEntity.MeadowlarkEntity.class, FlyingBirdEntity.MeadowlarkEntity::new, "geo/meadowlark.geo.json", "animations/small_bird.animation.json", "textures/model/entity/birds.png", 0.1f, class_4048.method_18385((float)0.4375f, (float)0.375f), "meadowlark", -1, -1, true, false, false));
        entityMap.put(EntityKey.WREN, new EntityMapEntry(EntityKey.WREN, FlyingBirdEntity.WrenEntity.class, FlyingBirdEntity.WrenEntity::new, "geo/wren.geo.json", "animations/small_bird.animation.json", "textures/model/entity/birds.png", 0.1f, class_4048.method_18385((float)0.4375f, (float)0.375f), "wren", -1, -1, true, false, false));
        entityMap.put(EntityKey.TOWHEE, new EntityMapEntry(EntityKey.TOWHEE, FlyingBirdEntity.TowheeEntity.class, FlyingBirdEntity.TowheeEntity::new, "geo/towhee.geo.json", "animations/small_bird.animation.json", "textures/model/entity/birds.png", 0.1f, class_4048.method_18385((float)0.4375f, (float)0.375f), "towhee", -1, -1, true, false, false));
        entityMap.put(EntityKey.CHICKADEE, new EntityMapEntry(EntityKey.CHICKADEE, FlyingBirdEntity.ChickadeeEntity.class, FlyingBirdEntity.ChickadeeEntity::new, "geo/chickadee.geo.json", "animations/small_bird.animation.json", "textures/model/entity/birds.png", 0.1f, class_4048.method_18385((float)0.4375f, (float)0.375f), "chickadee", -1, -1, true, false, false));
        entityMap.put(EntityKey.ROBIN, new EntityMapEntry(EntityKey.ROBIN, FlyingBirdEntity.RobinEntity.class, FlyingBirdEntity.RobinEntity::new, "geo/robin.geo.json", "animations/small_bird.animation.json", "textures/model/entity/birds.png", 0.1f, class_4048.method_18385((float)0.4375f, (float)0.375f), "robin", -1, -1, true, false, false));
        entityMap.put(EntityKey.LARK, new EntityMapEntry(EntityKey.LARK, FlyingBirdEntity.LarkEntity.class, FlyingBirdEntity.LarkEntity::new, "geo/lark.geo.json", "animations/small_bird.animation.json", "textures/model/entity/birds.png", 0.1f, class_4048.method_18385((float)0.4375f, (float)0.375f), "lark", -1, -1, true, false, false));
        entityMap.put(EntityKey.FLYCATCHER, new EntityMapEntry(EntityKey.FLYCATCHER, FlyingBirdEntity.FlycatcherEntity.class, FlyingBirdEntity.FlycatcherEntity::new, "geo/flycatcher.geo.json", "animations/small_bird.animation.json", "textures/model/entity/birds.png", 0.1f, class_4048.method_18385((float)0.4375f, (float)0.375f), "flycatcher", -1, -1, true, false, false));
        entityMap.put(EntityKey.WHITE_EYE, new EntityMapEntry(EntityKey.WHITE_EYE, FlyingBirdEntity.WhiteEyeEntity.class, FlyingBirdEntity.WhiteEyeEntity::new, "geo/white_eye.geo.json", "animations/small_bird.animation.json", "textures/model/entity/birds.png", 0.1f, class_4048.method_18385((float)0.4375f, (float)0.375f), "white_eye", -1, -1, true, false, false));
        entityMap.put(EntityKey.COTTONBIRD, new EntityMapEntry(EntityKey.COTTONBIRD, FlyingBirdEntity.CottonbirdEntity.class, FlyingBirdEntity.CottonbirdEntity::new, "geo/cottonbird.geo.json", "animations/small_bird.animation.json", "textures/model/entity/birds.png", 0.1f, class_4048.method_18385((float)0.4375f, (float)0.375f), "cottonbird", -1, -1, true, false, false));
        entityMap.put(EntityKey.SPARROW, new EntityMapEntry(EntityKey.SPARROW, FlyingBirdEntity.SparrowEntity.class, FlyingBirdEntity.SparrowEntity::new, "geo/sparrow.geo.json", "animations/small_bird.animation.json", "textures/model/entity/birds.png", 0.1f, class_4048.method_18385((float)0.4375f, (float)0.375f), "sparrow", -1, -1, true, false, false));
        entityMap.put(EntityKey.STICKBUG, new EntityMapEntry(EntityKey.STICKBUG, GroundInsectEntity.StickbugEntity.class, GroundInsectEntity.StickbugEntity::new, "geo/stickbug.geo.json", "animations/insect.animation.json", "textures/model/entity/bugs.png", 0.1f, class_4048.method_18385((float)0.5f, (float)0.25f), "stickbug", -1, -1, false, false, false));
        entityMap.put(EntityKey.SNAIL, new EntityMapEntry(EntityKey.SNAIL, GroundInsectEntity.SnailEntity.class, GroundInsectEntity.SnailEntity::new, "geo/snail.geo.json", "animations/snail.animation.json", "textures/model/entity/bugs.png", 0.25f, class_4048.method_18385((float)0.5f, (float)0.5f), "snail", -1, -1, false, false, false));
        entityMap.put(EntityKey.SPIDER, new EntityMapEntry(EntityKey.SPIDER, GroundInsectEntity.SpiderEntity.class, GroundInsectEntity.SpiderEntity::new, "geo/spider.geo.json", "animations/spider.animation.json", "textures/model/entity/bugs.png", 0.25f, class_4048.method_18385((float)0.625f, (float)0.25f), "spider", -1, -1, false, false, false));
        entityMap.put(EntityKey.ANT, new EntityMapEntry(EntityKey.ANT, GroundInsectEntity.AntEntity.class, GroundInsectEntity.AntEntity::new, "geo/ant.geo.json", "animations/insect.animation.json", "textures/model/entity/bugs.png", 0.25f, class_4048.method_18385((float)0.5f, (float)0.25f), "ant", -1, -1, false, false, false));
        entityMap.put(EntityKey.SUNFLOWERBEETLE, new EntityMapEntry(EntityKey.SUNFLOWERBEETLE, GroundInsectEntity.SunflowerBeetleEntity.class, GroundInsectEntity.SunflowerBeetleEntity::new, "geo/sunflowerbeetle.geo.json", "animations/insect.animation.json", "textures/model/entity/bugs.png", 0.25f, class_4048.method_18385((float)0.5f, (float)0.25f), "sunflowerbeetle", -1, -1, false, false, false));
        entityMap.put(EntityKey.LADYBUG, new EntityMapEntry(EntityKey.LADYBUG, GroundInsectEntity.LadybugEntity.class, GroundInsectEntity.LadybugEntity::new, "geo/ladybug.geo.json", "animations/insect.animation.json", "textures/model/entity/bugs.png", 0.25f, class_4048.method_18385((float)0.5f, (float)0.25f), "ladybug", -1, -1, false, false, false));
        entityMap.put(EntityKey.DRAGONFLY, new EntityMapEntry(EntityKey.DRAGONFLY, FlyingInsectEntity.DragonflyEntity.class, FlyingInsectEntity.DragonflyEntity::new, "geo/dragonfly.geo.json", "animations/dragonfly.animation.json", "textures/model/entity/bugs.png", 0.25f, class_4048.method_18385((float)0.5f, (float)0.25f), "dragonfly", -1, -1, false, false, false));
        entityMap.put(EntityKey.SPICEBUSH_BUTTERFLY, new EntityMapEntry(EntityKey.SPICEBUSH_BUTTERFLY, FlyingInsectEntity.SpicebushButterflyEntity.class, FlyingInsectEntity.SpicebushButterflyEntity::new, "geo/spicebush_butterfly.geo.json", "animations/butterfly.animation.json", "textures/model/entity/butterflies.png", 0.25f, class_4048.method_18385((float)0.5f, (float)0.25f), "spicebush_butterfly", -1, -1, false, false, false));
        entityMap.put(EntityKey.TIGER_BUTTERFLY, new EntityMapEntry(EntityKey.TIGER_BUTTERFLY, FlyingInsectEntity.TigerButterflyEntity.class, FlyingInsectEntity.TigerButterflyEntity::new, "geo/tiger_butterfly.geo.json", "animations/butterfly.animation.json", "textures/model/entity/butterflies.png", 0.25f, class_4048.method_18385((float)0.5f, (float)0.25f), "tiger_butterfly", -1, -1, false, false, false));
        entityMap.put(EntityKey.MORPHO_BUTTERFLY, new EntityMapEntry(EntityKey.MORPHO_BUTTERFLY, FlyingInsectEntity.MorphoButterflyEntity.class, FlyingInsectEntity.MorphoButterflyEntity::new, "geo/morpho_butterfly.geo.json", "animations/butterfly.animation.json", "textures/model/entity/butterflies.png", 0.25f, class_4048.method_18385((float)0.5f, (float)0.25f), "morpho_butterfly", -1, -1, false, false, false));
        entityMap.put(EntityKey.MONARCH_BUTTERFLY, new EntityMapEntry(EntityKey.MONARCH_BUTTERFLY, FlyingInsectEntity.MonarchButterflyEntity.class, FlyingInsectEntity.MonarchButterflyEntity::new, "geo/monarch_butterfly.geo.json", "animations/butterfly.animation.json", "textures/model/entity/butterflies.png", 0.25f, class_4048.method_18385((float)0.5f, (float)0.25f), "monarch_butterfly", -1, -1, false, false, false));
        entityMap.put(EntityKey.GLASSWING_BUTTERFLY, new EntityMapEntry(EntityKey.GLASSWING_BUTTERFLY, FlyingInsectEntity.GlasswingButterflyEntity.class, FlyingInsectEntity.GlasswingButterflyEntity::new, "geo/glasswing_butterfly.geo.json", "animations/butterfly.animation.json", "textures/model/entity/butterflies.png", 0.25f, class_4048.method_18385((float)0.5f, (float)0.25f), "glasswing_butterfly", -1, -1, false, false, false));
        entityMap.put(EntityKey.CRICKET, new EntityMapEntry(EntityKey.CRICKET, GroundInsectEntity.CricketEntity.class, GroundInsectEntity.CricketEntity::new, "geo/cricket.geo.json", "animations/cricket.animation.json", "textures/model/entity/bugs.png", 0.25f, class_4048.method_18385((float)0.25f, (float)0.25f), "cricket", -1, -1, false, false, false));
        for (EntityMapEntry entry : entityMap.values()) {
            classesForSettings.put(entry.key, entry.entityClass);
        }
    }

    public static void doServerInit() {
        if (entityMap.isEmpty()) {
            Entities.init();
        }
        for (EntityMapEntry entry : entityMap.values()) {
            entry.doServerRegistration();
        }
    }

    public static enum EntityKey {
        CRICKET,
        GLASSWING_BUTTERFLY,
        MONARCH_BUTTERFLY,
        MORPHO_BUTTERFLY,
        TIGER_BUTTERFLY,
        SPICEBUSH_BUTTERFLY,
        DRAGONFLY,
        LADYBUG,
        SUNFLOWERBEETLE,
        ANT,
        SPIDER,
        SNAIL,
        STICKBUG,
        JUNEBEETLE,
        RHINOBEETLE,
        STAGHORNBEETLE,
        SPARROW,
        COTTONBIRD,
        WHITE_EYE,
        FLYCATCHER,
        LARK,
        ROBIN,
        CHICKADEE,
        TOWHEE,
        WREN,
        MEADOWLARK,
        ORIOLE,
        BLUEBIRD,
        GOLDFINCH,
        PHOEBE,
        SWALLOW,
        BADGER,
        PORCUPINE,
        BEAVER,
        ARMADILLO,
        ANTEATER,
        POSSUM,
        CAPYBARA,
        BOAR,
        DEER,
        MONKEY,
        IGUANA,
        CRAB,
        HERMITCRAB,
        HEDGEHOG,
        FERRET,
        HAMSTER,
        CHAMELEON,
        GECKO,
        GRASS_SNAKE,
        MILK_SNAKE,
        PYTHON,
        KING_SNAKE,
        ALLIGATOR,
        BLUEGILL,
        KOI,
        BETTAFISH,
        GOLDFISH,
        PRAWN,
        SHRIMP,
        CATFISH,
        RAINBOW_TROUT,
        ANGLERFISH,
        JELLYFISH,
        GLOW_JELLYFISH,
        SEAHORSE,
        STINGRAY,
        MANTARAY,
        HAMMERHEAD_SHARK,
        CLAM,
        SEAURCHIN,
        STARFISH,
        HORSESHOE_CRAB,
        SANDDOLLAR;

    }

    public static class EntityMapEntry {
        public String path;
        public class_1299 type;
        public Class entityClass;
        public class_1792 item;
        public class_1792 item_albino;
        public class_1792 item_bucket;
        public class_1299.class_4049 entityFactory;
        public class_4048 dimensions;
        public EntityKey key;
        public int spawnEggColor = -1;
        public int spawnEggSpotColor = -1;
        public String geo;
        public String ani;
        public String tex;
        public float shadowRadius = 0.25f;
        public boolean shouldGlow = false;
        public boolean isTranslucent = false;
        public boolean hasMeat = false;

        public EntityMapEntry(EntityKey key, Class entityClass, class_1299.class_4049 entityFactory, String geo, String ani, String tex, float shadowRadius, class_4048 dimensions, String path, int spawnEggColor, int spawnEggSpotColor, boolean hasAlbino, boolean shouldGlow, boolean isTranslucent) {
            this.init(key, entityClass, entityFactory, geo, ani, tex, shadowRadius, dimensions, path, spawnEggColor, spawnEggSpotColor, hasAlbino, shouldGlow, isTranslucent, false);
        }

        public EntityMapEntry(EntityKey key, Class entityClass, class_1299.class_4049 entityFactory, String geo, String ani, String tex, float shadowRadius, class_4048 dimensions, String path, int spawnEggColor, int spawnEggSpotColor, boolean hasAlbino, boolean shouldGlow, boolean isTranslucent, boolean hasMeat) {
            this.init(key, entityClass, entityFactory, geo, ani, tex, shadowRadius, dimensions, path, spawnEggColor, spawnEggSpotColor, hasAlbino, shouldGlow, isTranslucent, hasMeat);
        }

        public void init(EntityKey key, Class entityClass, class_1299.class_4049 entityFactory, String geo, String ani, String tex, float shadowRadius, class_4048 dimensions, String path, int spawnEggColor, int spawnEggSpotColor, boolean hasAlbino, boolean shouldGlow, boolean isTranslucent, boolean hasMeat) {
            this.key = key;
            this.path = path;
            this.entityClass = entityClass;
            this.entityFactory = entityFactory;
            this.dimensions = dimensions;
            this.spawnEggColor = spawnEggColor;
            this.spawnEggSpotColor = spawnEggSpotColor;
            this.geo = geo;
            this.ani = ani;
            this.tex = tex;
            this.shadowRadius = shadowRadius;
            this.shouldGlow = shouldGlow;
            this.isTranslucent = isTranslucent;
            this.hasMeat = hasMeat;
            this.type = (class_1299)class_2378.method_10230((class_2378)class_7923.field_41177, (class_2960)new class_2960("wildlife", path), (Object)FabricEntityTypeBuilder.create((class_1311)class_1311.field_6294, (class_1299.class_4049)entityFactory).dimensions(dimensions).trackable(160, 2).build());
            if (spawnEggColor > 0) {
                this.item = new class_1826(this.type, spawnEggColor, spawnEggSpotColor, eggItemSettings);
            } else {
                this.item = new EntityItem((class_1792.class_1793)itemSettings, path, key);
                if (hasAlbino) {
                    this.item_albino = new EntityItem((class_1792.class_1793)itemSettings, path + "_albino", key);
                }
            }
            if (MediumAquaticWildlifeEntity.class.isAssignableFrom(entityClass)) {
                this.item_bucket = new class_1785(this.type, (class_3611)class_3612.field_15910, class_3417.field_14912, (class_1792.class_1793)bucketItemSettings);
            }
            if (hasMeat) {
                class_1792 raw_meat = new class_1792(new class_1792.class_1793().method_19265(class_4176.field_18647));
                class_1792 cooked_meat = new class_1792(new class_1792.class_1793().method_19265(class_4176.field_18650));
                class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)new class_2960("wildlife", "raw_" + path), (Object)raw_meat);
                ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_41061).register(entries -> entries.method_45421((class_1935)raw_meat));
                class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)new class_2960("wildlife", "cooked_" + path), (Object)cooked_meat);
                ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_41061).register(entries -> entries.method_45421((class_1935)cooked_meat));
            }
        }

        public void doServerRegistration() {
            class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)new class_2960("wildlife", this.path), (Object)this.item);
            ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40205).register(entries -> entries.method_45421((class_1935)this.item));
            if (this.item_albino != null) {
                class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)new class_2960("wildlife", this.path + "_albino"), (Object)this.item_albino);
                ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40205).register(entries -> entries.method_45421((class_1935)this.item_albino));
            }
            if (this.item_bucket != null) {
                class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)new class_2960("wildlife", this.path + "_bucket"), (Object)this.item_bucket);
                ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40205).register(entries -> entries.method_45421((class_1935)this.item_bucket));
            }
            FabricDefaultAttributeRegistry.register((class_1299)this.type, (class_5132.class_5133)WildlifeEntity.createWildlifeAttributes(this.key));
            SpawnSettings.initSpawnSettings(this.key, this.type, false);
        }
    }
}

