/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.tectonic.config.codec;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.tectonic.config.codec.ConfigCodec;

public record LegacyCodec(boolean modEnabled, Features features, Experimental experimental) {
    public static final Codec<LegacyCodec> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("mod_enabled").orElse((Object)true).forGetter(LegacyCodec::modEnabled), (App)Features.CODEC.fieldOf("features").orElse((Object)Features.DEFAULT).forGetter(LegacyCodec::features), (App)Experimental.CODEC.fieldOf("experimental").orElse((Object)Experimental.DEFAULT).forGetter(LegacyCodec::experimental)).apply((Applicative)instance, LegacyCodec::new));

    public ConfigCodec upgrade() {
        return new ConfigCodec(this.modEnabled, new ConfigCodec.Toggles(this.features.desertDunes, this.features.undergroundRivers, this.features.lavaRivers, this.features.deeperOceans, this.experimental.increasedHeight), new ConfigCodec.Scales(this.experimental.terrainScale, this.experimental.horizontalMountainScale, this.features.deeperOceans ? -0.15 : -0.12, this.features.deeperOceans ? -0.45 : -0.22), this.features.snowStartOffset);
    }

    public record Features(boolean deeperOceans, boolean desertDunes, boolean lavaRivers, int snowStartOffset, boolean undergroundRivers) {
        public static final Codec<Features> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("deeper_oceans").orElse((Object)true).forGetter(Features::deeperOceans), (App)Codec.BOOL.fieldOf("desert_dunes").orElse((Object)true).forGetter(Features::desertDunes), (App)Codec.BOOL.fieldOf("lava_rivers").orElse((Object)true).forGetter(Features::lavaRivers), (App)Codec.INT.fieldOf("snow_start_offset").orElse((Object)128).forGetter(Features::snowStartOffset), (App)Codec.BOOL.fieldOf("underground_rivers").orElse((Object)true).forGetter(Features::undergroundRivers)).apply((Applicative)instance, Features::new));
        public static final Features DEFAULT = new Features(true, true, true, 128, true);
    }

    public record Experimental(double horizontalMountainScale, boolean increasedHeight, double terrainScale) {
        public static final Codec<Experimental> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.fieldOf("horizontal_mountain_scale").orElse((Object)0.25).forGetter(Experimental::horizontalMountainScale), (App)Codec.BOOL.fieldOf("increased_height").orElse((Object)false).forGetter(Experimental::increasedHeight), (App)Codec.DOUBLE.fieldOf("terrain_scale").orElse((Object)1.125).forGetter(Experimental::terrainScale)).apply((Applicative)instance, Experimental::new));
        public static final Experimental DEFAULT = new Experimental(0.25, false, 1.125);
    }
}

