/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.tectonic.config.codec;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.tectonic.config.ConfigHandler;
import dev.worldgen.tectonic.config.codec.LegacyCodec;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public record ConfigCodec(boolean enabled, Toggles toggles, Scales scales, int snowOffset) {
    public static final Codec<ConfigCodec> BASE_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("enabled").forGetter(ConfigCodec::enabled), (App)Toggles.CODEC.fieldOf("feature_toggles").orElse((Object)Toggles.DEFAULT).forGetter(ConfigCodec::toggles), (App)Scales.CODEC.fieldOf("terrain_scales").orElse((Object)Scales.DEFAULT).forGetter(ConfigCodec::scales), (App)Codec.INT.fieldOf("snow_start_offset").orElse((Object)128).forGetter(ConfigCodec::snowOffset)).apply((Applicative)instance, ConfigCodec::new));
    public static final Codec<ConfigCodec> CODEC = Codec.either(BASE_CODEC, LegacyCodec.CODEC).xmap(either -> (ConfigCodec)either.map(v -> v, LegacyCodec::upgrade), Either::left);

    public double getValue(String option) {
        return switch (option) {
            case "final_multiplier" -> this.scales.finalMultiplier;
            case "erosion_scale" -> this.scales.erosionScale;
            case "ocean_depth" -> this.scales.ocean;
            case "deep_ocean_depth" -> this.scales.deepOcean;
            case "desert_dunes" -> {
                if (this.toggles.dunes) {
                    yield 1.0;
                }
                yield 0.0;
            }
            case "underground_rivers" -> {
                if (this.toggles.undergroundRivers) {
                    yield 1.0;
                }
                yield 0.0;
            }
            case "lava_rivers" -> {
                if (this.toggles.lavaRivers) {
                    yield 1.0;
                }
                yield 0.0;
            }
            default -> 0.0;
        };
    }

    private List<String> getEnabledPacks(boolean terralithEnabled) {
        ArrayList<String> enabledPacks = new ArrayList<String>();
        if (this.enabled) {
            if (this.toggles.increasedHeight) {
                enabledPacks.add(terralithEnabled ? "increased_height_terratonic" : "increased_height");
            }
            enabledPacks.add(terralithEnabled ? "terratonic" : "tectonic");
        }
        return enabledPacks;
    }

    public void enablePacks(boolean terralithEnabled, Consumer<String> registerPack) {
        for (String packName : ConfigHandler.getConfig().getEnabledPacks(terralithEnabled)) {
            registerPack.accept(packName);
        }
    }

    public record Toggles(String c1, String c2, boolean dunes, boolean undergroundRivers, boolean lavaRivers, boolean monumentOffset, boolean increasedHeight) {
        public static final String C1 = "Moves max height to y640";
        public static final String C2 = "Offsets ocean monuments 30 blocks down";
        public static final Codec<Toggles> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("i__").orElse((Object)C1).forGetter(Toggles::c1), (App)Codec.STRING.fieldOf("m__").orElse((Object)C2).forGetter(Toggles::c2), (App)Codec.BOOL.fieldOf("desert_dunes").orElse((Object)true).forGetter(Toggles::dunes), (App)Codec.BOOL.fieldOf("underground_rivers").orElse((Object)true).forGetter(Toggles::undergroundRivers), (App)Codec.BOOL.fieldOf("lava_rivers").orElse((Object)true).forGetter(Toggles::lavaRivers), (App)Codec.BOOL.fieldOf("monument_offset").orElse((Object)true).forGetter(Toggles::monumentOffset), (App)Codec.BOOL.fieldOf("increased_height").orElse((Object)false).forGetter(Toggles::increasedHeight)).apply((Applicative)instance, Toggles::new));
        public static final Toggles DEFAULT = new Toggles(true, true, true, true, false);

        public Toggles(boolean dunes, boolean undergroundRivers, boolean lavaRivers, boolean monumentOffset, boolean increasedHeight) {
            this(C1, C2, dunes, undergroundRivers, lavaRivers, monumentOffset, increasedHeight);
        }
    }

    public record Scales(String c1, String c2, String c3, String c4, double finalMultiplier, double erosionScale, double ocean, double deepOcean) {
        public static final String C1 = "Lower values = thicker mountain ranges and more space between ranges";
        public static final String C2 = "Vanilla value is -0.12";
        public static final String C3 = "Vanilla value is -0.22";
        public static final String C4 = "Higher values = vertically stretched terrain";
        public static final Codec<Scales> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("e__").orElse((Object)C1).forGetter(Scales::c1), (App)Codec.STRING.fieldOf("o__").orElse((Object)C2).forGetter(Scales::c2), (App)Codec.STRING.fieldOf("d__").orElse((Object)C3).forGetter(Scales::c3), (App)Codec.STRING.fieldOf("v__").orElse((Object)C4).forGetter(Scales::c4), (App)Codec.DOUBLE.fieldOf("vertical_multiplier").orElse((Object)1.125).forGetter(Scales::finalMultiplier), (App)Codec.DOUBLE.fieldOf("erosion_scale").orElse((Object)0.25).forGetter(Scales::erosionScale), (App)Codec.DOUBLE.fieldOf("ocean_depth").orElse((Object)-0.15).forGetter(Scales::ocean), (App)Codec.DOUBLE.fieldOf("deep_ocean_depth").orElse((Object)-0.45).forGetter(Scales::deepOcean)).apply((Applicative)instance, Scales::new));
        public static final Scales DEFAULT = new Scales(1.125, 0.25, -0.15, -0.45);

        public Scales(double finalMultiplier, double erosionScale, double ocean, double deepOcean) {
            this(C1, C2, C3, C4, finalMultiplier, erosionScale, ocean, deepOcean);
        }
    }
}

