/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.animatable;

import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import org.jetbrains.annotations.ApiStatus;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.network.GeckoLibNetwork;
import software.bernie.geckolib.network.SerializableDataTicket;
import software.bernie.geckolib.network.packet.EntityAnimDataSyncPacket;
import software.bernie.geckolib.network.packet.EntityAnimTriggerPacket;
import software.bernie.geckolib.network.packet.StopTriggeredEntityAnimPacket;

public interface GeoReplacedEntity
extends SingletonGeoAnimatable {
    public class_1299<?> getReplacingEntityType();

    @Nullable
    default public <D> D getAnimData(class_1297 entity, SerializableDataTicket<D> dataTicket) {
        return this.getAnimatableInstanceCache().getManagerForId(entity.method_5628()).getData(dataTicket);
    }

    default public <D> void setAnimData(class_1297 relatedEntity, SerializableDataTicket<D> dataTicket, D data) {
        if (relatedEntity.method_37908().method_8608()) {
            this.getAnimatableInstanceCache().getManagerForId(relatedEntity.method_5628()).setData(dataTicket, data);
        } else {
            GeckoLibNetwork.sendToTrackingEntityAndSelf(new EntityAnimDataSyncPacket<D>(relatedEntity.method_5628(), dataTicket, data), relatedEntity);
        }
    }

    default public void triggerAnim(class_1297 relatedEntity, @Nullable String controllerName, String animName) {
        if (relatedEntity.method_37908().method_8608()) {
            this.getAnimatableInstanceCache().getManagerForId(relatedEntity.method_5628()).tryTriggerAnimation(controllerName, animName);
        } else {
            GeckoLibNetwork.sendToTrackingEntityAndSelf(new EntityAnimTriggerPacket(relatedEntity.method_5628(), controllerName, animName), relatedEntity);
        }
    }

    @ApiStatus.NonExtendable
    default public void stopTriggeredAnimation(class_1297 relatedEntity, @Nullable String controllerName, @Nullable String animName) {
        if (relatedEntity.method_37908().method_8608()) {
            AnimatableManager animatableManager = this.getAnimatableInstanceCache().getManagerForId(relatedEntity.method_5628());
            if (animatableManager == null) {
                return;
            }
            if (controllerName != null) {
                animatableManager.stopTriggeredAnimation(controllerName, animName);
            } else {
                animatableManager.stopTriggeredAnimation(animName);
            }
        } else {
            GeckoLibNetwork.sendToTrackingEntityAndSelf(new StopTriggeredEntityAnimPacket(relatedEntity.method_5628(), controllerName, animName), relatedEntity);
        }
    }

    @Override
    default public double getTick(Object entity) {
        return ((class_1297)entity).field_6012;
    }

    @Override
    default public void createRenderer(Consumer<Object> consumer) {
    }

    @Override
    default public Supplier<Object> getRenderProvider() {
        return null;
    }
}

