/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.recipes;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_184;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2444;
import net.minecraft.class_2447;
import net.minecraft.class_2450;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_7800;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.recipes.AbstractBaseRecipeBuilder;
import org.betterx.bclib.recipes.BCLRecipeManager;

public class CraftingRecipeBuilder
extends AbstractBaseRecipeBuilder<CraftingRecipeBuilder> {
    private String[] shape;
    private boolean showNotification = true;
    protected final Map<String, class_184> unlocks = new HashMap<String, class_184>();
    protected final Map<Character, class_1856> materials = new HashMap<Character, class_1856>();

    protected CraftingRecipeBuilder(class_2960 id, class_1935 output) {
        super(id, output);
        this.shape = new String[]{"#"};
    }

    static CraftingRecipeBuilder make(class_2960 id, class_1935 output) {
        return new CraftingRecipeBuilder(id, output);
    }

    @Override
    public CraftingRecipeBuilder setOutputCount(int count) {
        return (CraftingRecipeBuilder)super.setOutputCount(count);
    }

    public CraftingRecipeBuilder addMaterial(char key, class_6862<class_1792> value) {
        this.unlockedBy((class_6862)value);
        this.materials.put(Character.valueOf(key), class_1856.method_8106(value));
        return this;
    }

    public CraftingRecipeBuilder addMaterial(char key, class_1799 ... values) {
        this.unlockedBy(values);
        return this.addMaterial(key, class_1856.method_26964(Arrays.stream(values)));
    }

    public CraftingRecipeBuilder addMaterial(char key, class_1935 ... values) {
        for (class_1935 item : values) {
            this.alright &= BCLRecipeManager.exists(item);
        }
        this.unlockedBy(values);
        return this.addMaterial(key, class_1856.method_8091((class_1935[])values));
    }

    private CraftingRecipeBuilder addMaterial(char key, class_1856 value) {
        this.materials.put(Character.valueOf(key), value);
        return this;
    }

    public CraftingRecipeBuilder setShape(String ... shape) {
        this.shape = shape;
        return this;
    }

    public CraftingRecipeBuilder shapeless() {
        this.shape = null;
        return this;
    }

    @Deprecated(forRemoval=true)
    public CraftingRecipeBuilder setList(String shape) {
        return this.shapeless();
    }

    public CraftingRecipeBuilder showNotification(boolean showNotification) {
        this.showNotification = showNotification;
        return this;
    }

    @Override
    public CraftingRecipeBuilder unlockedBy(class_1935 item) {
        return (CraftingRecipeBuilder)super.unlockedBy(item);
    }

    @Override
    public CraftingRecipeBuilder unlockedBy(class_6862<class_1792> tag) {
        return (CraftingRecipeBuilder)super.unlockedBy(tag);
    }

    @Override
    public CraftingRecipeBuilder unlockedBy(class_1935 ... items) {
        return (CraftingRecipeBuilder)super.unlockedBy(items);
    }

    @Override
    public CraftingRecipeBuilder unlockedBy(class_1799 ... stacks) {
        return (CraftingRecipeBuilder)super.unlockedBy(stacks);
    }

    @Override
    protected CraftingRecipeBuilder unlocks(String name, class_184 trigger) {
        this.unlocks.put(name, trigger);
        return this;
    }

    @Override
    public CraftingRecipeBuilder setGroup(String group) {
        return (CraftingRecipeBuilder)super.setGroup(group);
    }

    @Override
    protected boolean checkRecipe() {
        if (this.shape != null) {
            return this.checkShaped();
        }
        return this.checkShapeless();
    }

    @Override
    protected void buildRecipe(Consumer<class_2444> cc) {
        if (this.shape != null) {
            this.buildShaped(cc);
        } else {
            this.buildShapeless(cc);
        }
    }

    protected boolean checkShapeless() {
        if (this.materials.size() == 0) {
            BCLib.LOGGER.warning("Recipe {} does not contain a material!", this.id);
            return false;
        }
        return super.checkRecipe();
    }

    protected void buildShapeless(Consumer<class_2444> cc) {
        class_2450 builder = class_2450.method_10448((class_7800)this.category, (class_1935)this.output.method_7909(), (int)this.output.method_7947());
        for (Map.Entry<String, class_184> entry : this.unlocks.entrySet()) {
            builder.method_10442(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : this.materials.entrySet()) {
            builder.method_10451((class_1856)entry.getValue());
        }
        builder.method_10452(this.group);
        builder.method_17972(cc, this.id);
    }

    protected boolean checkShaped() {
        int i;
        if (this.shape == null || this.shape.length == 0) {
            BCLib.LOGGER.warning("Recipe {} does not contain a shape!", this.id);
            return false;
        }
        if (this.shape.length > 3) {
            BCLib.LOGGER.warning("Recipe {} shape contains more than three lines!", this.id);
            return false;
        }
        int width = this.shape[0].length();
        if (width > 3) {
            BCLib.LOGGER.warning("Recipe {} shape is wider than three!", this.id);
            return false;
        }
        Object allLines = "";
        for (i = 0; i < this.shape.length; ++i) {
            if (this.shape[i].length() != width) {
                BCLib.LOGGER.warning("All lines in the shape of Recipe {} should be the same length!", this.id);
                return false;
            }
            allLines = (String)allLines + this.shape[i];
        }
        if (((String)(allLines = ((String)allLines).replaceAll(" ", ""))).length() == 1) {
            BCLib.LOGGER.warning("Recipe {} only takes in a single item and should be shapeless", this.id);
            return false;
        }
        for (i = 0; i < ((String)allLines).length(); ++i) {
            char c = ((String)allLines).charAt(i);
            if (this.materials.containsKey(Character.valueOf(c))) continue;
            BCLib.LOGGER.warning("Recipe {} is missing the material definition for '" + c + "'!", this.id);
            return false;
        }
        return super.checkRecipe();
    }

    protected void buildShaped(Consumer<class_2444> cc) {
        class_2447 builder = class_2447.method_10436((class_7800)this.category, (class_1935)this.output.method_7909(), (int)this.output.method_7947());
        for (Map.Entry<String, class_184> entry : this.unlocks.entrySet()) {
            builder.method_10429(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : this.materials.entrySet()) {
            builder.method_10428((Character)entry.getKey(), (class_1856)entry.getValue());
        }
        for (Iterator<Map.Entry<Object, Object>> iterator : this.shape) {
            builder.method_10439(iterator);
        }
        builder.method_10435(this.group);
        builder.method_49380(this.showNotification);
        builder.method_17972(cc, this.id);
    }
}

