/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1831;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.interfaces.UnknownReceipBookCategory;
import org.betterx.bclib.recipes.AbstractSingleInputRecipeBuilder;
import org.betterx.bclib.recipes.BCLRecipeManager;
import org.betterx.bclib.util.ItemUtil;
import org.betterx.worlds.together.tag.v3.CommonItemTags;
import org.betterx.worlds.together.world.event.WorldBootstrap;
import org.jetbrains.annotations.NotNull;

public class AnvilRecipe
implements class_1860<class_1263>,
UnknownReceipBookCategory {
    public static final String GROUP = "smithing";
    public static final class_3956<AnvilRecipe> TYPE = BCLRecipeManager.registerType("bclib", "smithing");
    public static final Serializer SERIALIZER = BCLRecipeManager.registerSerializer("bclib", "smithing", new Serializer());
    public static final class_2960 ID = BCLib.makeID("smithing");
    private final class_2960 id;
    private final class_1856 input;
    private final class_1799 output;
    private final int damage;
    private final int toolLevel;
    private final int anvilLevel;
    private final int inputCount;

    public static void register() {
    }

    public AnvilRecipe(class_2960 identifier, class_1856 input, class_1799 output, int inputCount, int toolLevel, int anvilLevel, int damage) {
        this.id = identifier;
        this.input = input;
        this.output = output;
        this.toolLevel = toolLevel;
        this.anvilLevel = anvilLevel;
        this.inputCount = inputCount;
        this.damage = damage;
    }

    static Builder create(class_2960 id, class_1935 output) {
        return new Builder(id, output);
    }

    public class_1865<?> method_8119() {
        return SERIALIZER;
    }

    public class_1799 method_8110(class_5455 acc) {
        return this.output;
    }

    public boolean method_8115(@NotNull class_1263 craftingInventory, @NotNull class_1937 world) {
        return this.matches(craftingInventory);
    }

    public class_1799 method_8116(@NotNull class_1263 craftingInventory, class_5455 acc) {
        return this.output.method_7972();
    }

    public static Iterable<class_6880<class_1792>> getAllHammers() {
        class_2378 registry = WorldBootstrap.getLastRegistryAccessOrElseBuiltin().method_30530(CommonItemTags.HAMMERS.comp_326());
        return registry.method_40286(CommonItemTags.HAMMERS);
    }

    public static int getHammerSlot(class_1263 c) {
        class_1799 h = c.method_5438(0);
        if (!h.method_7960() && h.method_31573(CommonItemTags.HAMMERS)) {
            return 0;
        }
        return 1;
    }

    public static int getIngredientSlot(class_1263 c) {
        return Math.abs(AnvilRecipe.getHammerSlot(c) - 1);
    }

    public class_1799 getHammer(class_1263 c) {
        class_1799 h = c.method_5438(1);
        if (!h.method_7960() && h.method_31573(CommonItemTags.HAMMERS)) {
            return h;
        }
        h = c.method_5438(0);
        if (!h.method_7960() && h.method_31573(CommonItemTags.HAMMERS)) {
            return h;
        }
        return null;
    }

    public class_1799 getIngredient(class_1263 c) {
        class_1799 i = c.method_5438(0);
        if (i.method_31573(CommonItemTags.HAMMERS)) {
            i = c.method_5438(1);
        }
        return i;
    }

    public class_1799 craft(class_1263 craftingInventory, class_1657 player) {
        if (!player.method_7337()) {
            if (!this.checkHammerDurability(craftingInventory, player)) {
                return class_1799.field_8037;
            }
            class_1799 hammer = this.getHammer(craftingInventory);
            if (hammer != null) {
                hammer.method_7956(this.damage, (class_1309)player, entity -> entity.method_20236((class_1268)null));
                return class_1799.field_8037;
            }
        }
        return this.method_8116(craftingInventory, class_310.method_1551().field_1687.method_30349());
    }

    public boolean checkHammerDurability(class_1263 craftingInventory, class_1657 player) {
        if (player.method_7337()) {
            return true;
        }
        class_1799 hammer = this.getHammer(craftingInventory);
        if (hammer != null) {
            int damage = hammer.method_7919() + this.damage;
            return damage < hammer.method_7936();
        }
        return true;
    }

    public boolean matches(class_1263 craftingInventory) {
        class_1799 hammer = this.getHammer(craftingInventory);
        if (hammer == null) {
            return false;
        }
        class_1799 material = this.getIngredient(craftingInventory);
        int materialCount = material.method_7947();
        int level = ((class_1831)hammer.method_7909()).method_8022().method_8024();
        return this.input.method_8093(this.getIngredient(craftingInventory)) && materialCount >= this.inputCount && level >= this.toolLevel;
    }

    public int getDamage() {
        return this.damage;
    }

    public int getInputCount() {
        return this.inputCount;
    }

    public class_1856 getMainIngredient() {
        return this.input;
    }

    public int getAnvilLevel() {
        return this.anvilLevel;
    }

    public boolean canUse(class_1792 tool) {
        if (tool instanceof class_1831) {
            class_1831 ti = (class_1831)tool;
            return ti.method_8022().method_8024() >= this.toolLevel;
        }
        return false;
    }

    public static boolean isHammer(class_1792 tool) {
        if (tool == null) {
            return false;
        }
        return tool.method_7854().method_31573(CommonItemTags.HAMMERS);
    }

    public class_2371<class_1856> method_8117() {
        class_2371 defaultedList = class_2371.method_10211();
        defaultedList.add((Object)class_1856.method_26964(class_7923.field_41178.method_10220().filter(AnvilRecipe::isHammer).filter(this::canUse).map(class_1799::new)));
        defaultedList.add((Object)this.input);
        return defaultedList;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean method_8113(int width, int height) {
        return true;
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public class_3956<?> method_17716() {
        return TYPE;
    }

    public boolean method_8118() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnvilRecipe that = (AnvilRecipe)o;
        return this.damage == that.damage && this.toolLevel == that.toolLevel && this.id.equals((Object)that.id) && this.input.equals(that.input) && this.output.equals(that.output);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.input, this.output, this.damage, this.toolLevel);
    }

    public String toString() {
        return "AnvilRecipe [" + this.id + "]";
    }

    public static class Builder
    extends AbstractSingleInputRecipeBuilder<Builder, AnvilRecipe> {
        private int inputCount = 1;
        private int toolLevel = 1;
        private int anvilLevel = 1;
        private int damage = 1;

        protected Builder(class_2960 id, class_1935 output) {
            super(id, output);
        }

        @Override
        protected Builder setOutputTag(class_2487 tag) {
            return (Builder)super.setOutputTag(tag);
        }

        @Override
        protected Builder setOutputCount(int count) {
            return (Builder)super.setOutputCount(count);
        }

        @Deprecated(forRemoval=true)
        public Builder setInput(class_1935 ... inputItems) {
            return (Builder)super.setPrimaryInput(inputItems);
        }

        @Deprecated(forRemoval=true)
        public Builder setInput(class_6862<class_1792> inputTag) {
            return (Builder)super.setPrimaryInput(inputTag);
        }

        @Deprecated(forRemoval=true)
        public Builder setInput(class_1856 ingredient) {
            this.primaryInput = ingredient;
            return this;
        }

        public Builder setInputCount(int count) {
            this.inputCount = count;
            return this;
        }

        public Builder setToolLevel(int level) {
            this.toolLevel = level;
            return this;
        }

        public Builder setAnvilLevel(int level) {
            this.anvilLevel = level;
            return this;
        }

        public Builder setDamage(int damage) {
            this.damage = damage;
            return this;
        }

        @Override
        protected class_1865<AnvilRecipe> getSerializer() {
            return SERIALIZER;
        }

        @Override
        protected boolean checkRecipe() {
            if (this.inputCount <= 0) {
                BCLib.LOGGER.warning("Number of input items for Recipe must be positive. Recipe {} will be ignored!", this.id);
                return false;
            }
            return super.checkRecipe();
        }

        @Override
        protected void serializeRecipeData(JsonObject root) {
            super.serializeRecipeData(root);
            if (this.inputCount > 1) {
                root.addProperty("inputCount", (Number)this.inputCount);
            }
            if (this.toolLevel != 1) {
                root.addProperty("toolLevel", (Number)this.toolLevel);
            }
            if (this.anvilLevel != 1) {
                root.addProperty("anvilLevel", (Number)this.anvilLevel);
            }
            if (this.damage != 1) {
                root.addProperty("damage", (Number)this.damage);
            }
        }
    }

    public static class Serializer
    implements class_1865<AnvilRecipe> {
        public AnvilRecipe fromJson(class_2960 id, JsonObject json) {
            class_1856 input = class_1856.method_52177((JsonElement)json.get("input"));
            JsonObject result = class_3518.method_15296((JsonObject)json, (String)"result");
            class_1799 output = ItemUtil.fromJsonRecipeWithNBT(result);
            if (output == null) {
                throw new IllegalStateException("Output item does not exists!");
            }
            int inputCount = class_3518.method_15282((JsonObject)json, (String)"inputCount", (int)1);
            int toolLevel = class_3518.method_15282((JsonObject)json, (String)"toolLevel", (int)1);
            int anvilLevel = class_3518.method_15282((JsonObject)json, (String)"anvilLevel", (int)1);
            int damage = class_3518.method_15282((JsonObject)json, (String)"damage", (int)1);
            return new AnvilRecipe(id, input, output, inputCount, toolLevel, anvilLevel, damage);
        }

        public AnvilRecipe fromNetwork(class_2960 id, class_2540 packetBuffer) {
            class_1856 input = class_1856.method_8086((class_2540)packetBuffer);
            class_1799 output = packetBuffer.method_10819();
            int inputCount = packetBuffer.method_10816();
            int toolLevel = packetBuffer.method_10816();
            int anvilLevel = packetBuffer.method_10816();
            int damage = packetBuffer.method_10816();
            return new AnvilRecipe(id, input, output, inputCount, toolLevel, anvilLevel, damage);
        }

        public void toNetwork(class_2540 packetBuffer, AnvilRecipe recipe) {
            recipe.input.method_8088(packetBuffer);
            packetBuffer.method_10793(recipe.output);
            packetBuffer.method_10804(recipe.inputCount);
            packetBuffer.method_10804(recipe.toolLevel);
            packetBuffer.method_10804(recipe.anvilLevel);
            packetBuffer.method_10804(recipe.damage);
        }
    }
}

