/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.fabric.config;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.List;
import net.blay09.mods.balm.api.config.BalmConfigData;
import net.blay09.mods.balm.api.config.Comment;
import net.blay09.mods.balm.api.network.ConfigReflection;
import net.blay09.mods.balm.notoml.Notoml;
import net.blay09.mods.balm.notoml.NotomlSerializer;
import org.slf4j.Logger;

public class FabricConfigSaver {
    private static final Logger logger = LogUtils.getLogger();

    public static Notoml toNotoml(BalmConfigData configData) {
        HashBasedTable properties = HashBasedTable.create();
        HashBasedTable comments = HashBasedTable.create();
        for (Field rootField : ConfigReflection.getAllFields(configData.getClass())) {
            String category;
            boolean isCategory = !FabricConfigSaver.isPropertyType(rootField.getType());
            String string = category = isCategory ? rootField.getName() : "";
            if (isCategory) {
                Comment categoryComment = rootField.getAnnotation(Comment.class);
                if (categoryComment != null) {
                    comments.put((Object)category, (Object)"", (Object)categoryComment.value());
                }
                try {
                    Object categoryInstance = rootField.get(configData);
                    for (Field propertyField : ConfigReflection.getAllFields(categoryInstance.getClass())) {
                        String property = propertyField.getName();
                        Comment propertyComment = propertyField.getAnnotation(Comment.class);
                        if (propertyComment != null) {
                            comments.put((Object)category, (Object)property, (Object)propertyComment.value());
                        }
                        try {
                            Object value = propertyField.get(categoryInstance);
                            properties.put((Object)category, (Object)property, value);
                        }
                        catch (Exception e) {
                            logger.error("Failed to save config category {}", (Object)category, (Object)e);
                        }
                    }
                    continue;
                }
                catch (Exception e) {
                    logger.error("Failed to save config category {}", (Object)category, (Object)e);
                    continue;
                }
            }
            try {
                String property = rootField.getName();
                Comment propertyComment = rootField.getAnnotation(Comment.class);
                if (propertyComment != null) {
                    comments.put((Object)category, (Object)property, (Object)propertyComment.value());
                }
                Object value = rootField.get(configData);
                properties.put((Object)category, (Object)property, value);
            }
            catch (Exception e) {
                logger.error("Failed to save config property {}", (Object)rootField.getName(), (Object)e);
            }
        }
        return new Notoml((Table<String, String, Object>)properties, (Table<String, String, String>)comments);
    }

    public static void save(File configFile, BalmConfigData configData) throws IOException {
        Notoml notoml = FabricConfigSaver.toNotoml(configData);
        try (FileWriter writer = new FileWriter(configFile);){
            NotomlSerializer.serialize(writer, notoml);
        }
    }

    private static boolean isPropertyType(Class<?> type) {
        return type.isPrimitive() || type == String.class || type == Integer.class || type == Boolean.class || type == Float.class || type == Double.class || type == List.class || Enum.class.isAssignableFrom(type);
    }
}

