/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.station;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllPackets;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.Create;
import com.simibubi.create.compat.computercraft.AbstractComputerBehaviour;
import com.simibubi.create.compat.computercraft.ComputerCraftProxy;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.ITransformableBlockEntity;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.decoration.slidingDoor.DoorControlBehaviour;
import com.simibubi.create.content.logistics.depot.DepotBehaviour;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkBlock;
import com.simibubi.create.content.trains.bogey.AbstractBogeyBlock;
import com.simibubi.create.content.trains.bogey.AbstractBogeyBlockEntity;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.CarriageBogey;
import com.simibubi.create.content.trains.entity.CarriageContraption;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.entity.TrainPacket;
import com.simibubi.create.content.trains.entity.TravellingPoint;
import com.simibubi.create.content.trains.graph.DiscoveredPath;
import com.simibubi.create.content.trains.graph.EdgePointType;
import com.simibubi.create.content.trains.graph.TrackEdge;
import com.simibubi.create.content.trains.graph.TrackGraph;
import com.simibubi.create.content.trains.graph.TrackGraphLocation;
import com.simibubi.create.content.trains.graph.TrackNode;
import com.simibubi.create.content.trains.graph.TrackNodeLocation;
import com.simibubi.create.content.trains.schedule.Schedule;
import com.simibubi.create.content.trains.schedule.ScheduleItem;
import com.simibubi.create.content.trains.station.GlobalStation;
import com.simibubi.create.content.trains.station.StationBlock;
import com.simibubi.create.content.trains.track.ITrackBlock;
import com.simibubi.create.content.trains.track.TrackTargetingBehaviour;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.WorldAttached;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import me.pepperbell.simplenetworking.S2CPacket;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SidedStorageBlockEntity;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3341;
import net.minecraft.class_3419;
import net.minecraft.class_3532;

public class StationBlockEntity
extends SmartBlockEntity
implements ITransformableBlockEntity,
SidedStorageBlockEntity {
    public TrackTargetingBehaviour<GlobalStation> edgePoint;
    public DoorControlBehaviour doorControls;
    public LerpedFloat flag;
    protected int failedCarriageIndex;
    protected AssemblyException lastException;
    protected DepotBehaviour depotBehaviour;
    public AbstractComputerBehaviour computerBehaviour;
    UUID imminentTrain;
    boolean trainPresent;
    boolean trainBackwards;
    boolean trainCanDisassemble;
    boolean trainHasSchedule;
    boolean trainHasAutoSchedule;
    int flagYRot = -1;
    boolean flagFlipped;
    public class_2561 lastDisassembledTrainName;
    public static WorldAttached<Map<class_2338, class_3341>> assemblyAreas = new WorldAttached<Map>(w -> new HashMap());
    class_2350 assemblyDirection;
    int assemblyLength;
    int[] bogeyLocations;
    AbstractBogeyBlock<?>[] bogeyTypes;
    boolean[] upsideDownBogeys;
    int bogeyCount;

    public StationBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.setLazyTickRate(20);
        this.lastException = null;
        this.failedCarriageIndex = -1;
        this.flag = LerpedFloat.linear().startWithValue(0.0);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.edgePoint = new TrackTargetingBehaviour<GlobalStation>(this, EdgePointType.STATION);
        behaviours.add(this.edgePoint);
        this.doorControls = new DoorControlBehaviour(this);
        behaviours.add(this.doorControls);
        this.depotBehaviour = new DepotBehaviour(this).onlyAccepts(arg_0 -> AllItems.SCHEDULE.isIn(arg_0)).withCallback(s -> this.applyAutoSchedule());
        behaviours.add(this.depotBehaviour);
        this.depotBehaviour.addSubBehaviours(behaviours);
        this.registerAwardables(behaviours, AllAdvancements.CONTRAPTION_ACTORS, AllAdvancements.TRAIN, AllAdvancements.LONG_TRAIN, AllAdvancements.CONDUCTOR);
        this.computerBehaviour = ComputerCraftProxy.behaviour(this);
        behaviours.add(this.computerBehaviour);
    }

    @Override
    protected void read(class_2487 tag, boolean clientPacket) {
        this.lastException = AssemblyException.read(tag);
        this.failedCarriageIndex = tag.method_10550("FailedCarriageIndex");
        super.read(tag, clientPacket);
        this.invalidateRenderBoundingBox();
        if (tag.method_10545("ForceFlag")) {
            this.trainPresent = tag.method_10577("ForceFlag");
        }
        if (tag.method_10545("PrevTrainName")) {
            this.lastDisassembledTrainName = class_2561.class_2562.method_10877((String)tag.method_10558("PrevTrainName"));
        }
        if (!clientPacket) {
            return;
        }
        if (!tag.method_10545("ImminentTrain")) {
            this.imminentTrain = null;
            this.trainPresent = false;
            this.trainCanDisassemble = false;
            this.trainBackwards = false;
            return;
        }
        this.imminentTrain = tag.method_25926("ImminentTrain");
        this.trainPresent = tag.method_10545("TrainPresent");
        this.trainCanDisassemble = tag.method_10545("TrainCanDisassemble");
        this.trainBackwards = tag.method_10545("TrainBackwards");
        this.trainHasSchedule = tag.method_10545("TrainHasSchedule");
        this.trainHasAutoSchedule = tag.method_10545("TrainHasAutoSchedule");
    }

    @Override
    protected void write(class_2487 tag, boolean clientPacket) {
        AssemblyException.write(tag, this.lastException);
        tag.method_10569("FailedCarriageIndex", this.failedCarriageIndex);
        if (this.lastDisassembledTrainName != null) {
            tag.method_10582("PrevTrainName", class_2561.class_2562.method_10867((class_2561)this.lastDisassembledTrainName));
        }
        super.write(tag, clientPacket);
        if (!clientPacket) {
            return;
        }
        if (this.imminentTrain == null) {
            return;
        }
        tag.method_25927("ImminentTrain", this.imminentTrain);
        if (this.trainPresent) {
            NBTHelper.putMarker(tag, "TrainPresent");
        }
        if (this.trainCanDisassemble) {
            NBTHelper.putMarker(tag, "TrainCanDisassemble");
        }
        if (this.trainBackwards) {
            NBTHelper.putMarker(tag, "TrainBackwards");
        }
        if (this.trainHasSchedule) {
            NBTHelper.putMarker(tag, "TrainHasSchedule");
        }
        if (this.trainHasAutoSchedule) {
            NBTHelper.putMarker(tag, "TrainHasAutoSchedule");
        }
    }

    @Nullable
    public GlobalStation getStation() {
        return this.edgePoint.getEdgePoint();
    }

    @Override
    public void lazyTick() {
        if (this.isAssembling() && !this.field_11863.field_9236) {
            this.refreshAssemblyInfo();
        }
        super.lazyTick();
    }

    @Override
    public void tick() {
        boolean newlyArrived;
        if (this.isAssembling() && this.field_11863.field_9236) {
            this.refreshAssemblyInfo();
        }
        super.tick();
        if (this.field_11863.field_9236) {
            float currentTarget = this.flag.getChaseTarget();
            if (currentTarget == 0.0f || this.flag.settled()) {
                boolean target;
                boolean bl = target = this.trainPresent || this.isAssembling();
                if ((float)target != currentTarget) {
                    this.flag.chase((double)target, 0.1f, LerpedFloat.Chaser.LINEAR);
                    if (target) {
                        AllSoundEvents.CONTRAPTION_ASSEMBLE.playAt(this.field_11863, (class_2382)this.field_11867, 1.0f, 2.0f, true);
                    }
                }
            }
            boolean settled = this.flag.getValue() > 0.15f;
            this.flag.tickChaser();
            if (currentTarget == 0.0f && settled != this.flag.getValue() > 0.15f) {
                AllSoundEvents.CONTRAPTION_DISASSEMBLE.playAt(this.field_11863, (class_2382)this.field_11867, 0.75f, 1.5f, true);
            }
            return;
        }
        GlobalStation station = this.getStation();
        if (station == null) {
            return;
        }
        Train imminentTrain = station.getImminentTrain();
        boolean trainPresent = imminentTrain != null && imminentTrain.getCurrentStation() == station;
        boolean canDisassemble = trainPresent && imminentTrain.canDisassemble();
        UUID imminentID = imminentTrain != null ? imminentTrain.id : null;
        boolean trainHasSchedule = trainPresent && imminentTrain.runtime.getSchedule() != null;
        boolean trainHasAutoSchedule = trainHasSchedule && imminentTrain.runtime.isAutoSchedule;
        boolean bl = newlyArrived = this.trainPresent != trainPresent;
        if (trainPresent && imminentTrain.runtime.displayLinkUpdateRequested) {
            DisplayLinkBlock.notifyGatherers((class_1936)this.field_11863, this.field_11867);
            imminentTrain.runtime.displayLinkUpdateRequested = false;
        }
        if (newlyArrived) {
            this.applyAutoSchedule();
        }
        if (newlyArrived || this.trainCanDisassemble != canDisassemble || !Objects.equals(imminentID, this.imminentTrain) || this.trainHasSchedule != trainHasSchedule || this.trainHasAutoSchedule != trainHasAutoSchedule) {
            this.imminentTrain = imminentID;
            this.trainPresent = trainPresent;
            this.trainCanDisassemble = canDisassemble;
            this.trainBackwards = imminentTrain != null && imminentTrain.currentlyBackwards;
            this.trainHasSchedule = trainHasSchedule;
            this.trainHasAutoSchedule = trainHasAutoSchedule;
            this.notifyUpdate();
        }
    }

    public boolean trackClicked(class_1657 player, class_1268 hand, ITrackBlock track, class_2680 state, class_2338 pos) {
        class_2338 targetPos;
        AbstractBogeyBlock bogey;
        class_2248 upsideDown2;
        this.refreshAssemblyInfo();
        class_3341 bb = assemblyAreas.get((class_1936)this.field_11863).get(this.field_11867);
        if (bb == null || !bb.method_14662((class_2382)pos)) {
            return false;
        }
        class_2338 up = class_2338.method_49638((class_2374)track.getUpNormal((class_1922)this.field_11863, pos, state));
        class_2338 down = class_2338.method_49638((class_2374)track.getUpNormal((class_1922)this.field_11863, pos, state).method_1021(-1.0));
        int bogeyOffset = pos.method_19455((class_2382)this.edgePoint.getGlobalPosition()) - 1;
        if (!this.isValidBogeyOffset(bogeyOffset)) {
            for (boolean upsideDown2 : Iterate.falseAndTrue) {
                for (int i = -1; i <= 1; ++i) {
                    class_2338 bogeyPos = pos.method_10079(this.assemblyDirection, i).method_10081((class_2382)(upsideDown2 ? down : up));
                    class_2680 blockState = this.field_11863.method_8320(bogeyPos);
                    class_2248 class_22482 = blockState.method_26204();
                    if (!(class_22482 instanceof AbstractBogeyBlock)) continue;
                    AbstractBogeyBlock bogey2 = (AbstractBogeyBlock)class_22482;
                    class_2586 be = this.field_11863.method_8321(bogeyPos);
                    if (!(be instanceof AbstractBogeyBlockEntity)) continue;
                    AbstractBogeyBlockEntity oldBE = (AbstractBogeyBlockEntity)be;
                    class_2487 oldData = oldBE.getBogeyData();
                    class_2680 newBlock = bogey2.getNextSize(oldBE);
                    if (newBlock.method_26204() == bogey2) {
                        player.method_7353((class_2561)Lang.translateDirect("bogey.style.no_other_sizes", new Object[0]).method_27692(class_124.field_1061), true);
                    }
                    this.field_11863.method_8652(bogeyPos, newBlock, 3);
                    class_2586 newEntity = this.field_11863.method_8321(bogeyPos);
                    if (!(newEntity instanceof AbstractBogeyBlockEntity)) continue;
                    AbstractBogeyBlockEntity newBE = (AbstractBogeyBlockEntity)newEntity;
                    newBE.setBogeyData(oldData);
                    bogey2.playRotateSound(this.field_11863, bogeyPos);
                    return true;
                }
            }
            return false;
        }
        class_1799 handItem = player.method_5998(hand);
        if (!player.method_7337() && !AllBlocks.RAILWAY_CASING.isIn(handItem)) {
            player.method_7353((class_2561)Lang.translateDirect("train_assembly.requires_casing", new Object[0]), true);
            return false;
        }
        boolean upsideDown3 = player.method_5695(1.0f) < 0.0f && (upsideDown2 = track.getBogeyAnchor((class_1922)this.field_11863, pos, state).method_26204()) instanceof AbstractBogeyBlock && (bogey = (AbstractBogeyBlock)upsideDown2).canBeUpsideDown();
        class_2338 class_23382 = targetPos = upsideDown3 ? pos.method_10081((class_2382)down) : pos.method_10081((class_2382)up);
        if (this.field_11863.method_8320(targetPos).method_26214((class_1922)this.field_11863, targetPos) == -1.0f) {
            return false;
        }
        this.field_11863.method_22352(targetPos, true);
        class_2680 bogeyAnchor = track.getBogeyAnchor((class_1922)this.field_11863, pos, state);
        class_2248 bogeyPos = bogeyAnchor.method_26204();
        if (bogeyPos instanceof AbstractBogeyBlock) {
            AbstractBogeyBlock bogey3 = (AbstractBogeyBlock)bogeyPos;
            bogeyAnchor = bogey3.getVersion(bogeyAnchor, upsideDown3);
        }
        bogeyAnchor = ProperWaterloggedBlock.withWater((class_1936)this.field_11863, bogeyAnchor, pos);
        this.field_11863.method_8652(targetPos, bogeyAnchor, 3);
        player.method_7353((class_2561)Lang.translateDirect("train_assembly.bogey_created", new Object[0]), true);
        class_2498 soundtype = bogeyAnchor.method_26204().method_9573(state);
        this.field_11863.method_8396(null, pos, soundtype.method_10598(), class_3419.field_15245, (soundtype.method_10597() + 1.0f) / 2.0f, soundtype.method_10599() * 0.8f);
        if (!player.method_7337()) {
            class_1799 itemInHand = player.method_5998(hand);
            itemInHand.method_7934(1);
            if (itemInHand.method_7960()) {
                player.method_6122(hand, class_1799.field_8037);
            }
        }
        return true;
    }

    public boolean enterAssemblyMode(@Nullable class_3222 sender) {
        if (this.isAssembling()) {
            return false;
        }
        this.tryDisassembleTrain(sender);
        if (!this.tryEnterAssemblyMode()) {
            return false;
        }
        if (!(this.field_11863.method_8320(this.field_11867).method_26204() instanceof StationBlock)) {
            return true;
        }
        class_2680 newState = (class_2680)this.method_11010().method_11657((class_2769)StationBlock.ASSEMBLING, (Comparable)Boolean.valueOf(true));
        this.field_11863.method_8652(this.method_11016(), newState, 3);
        this.refreshBlockState();
        this.refreshAssemblyInfo();
        this.updateStationState(station -> {
            station.assembling = true;
        });
        GlobalStation station2 = this.getStation();
        if (station2 != null) {
            for (Train train : Create.RAILWAYS.sided((class_1936)this.field_11863).trains.values()) {
                if (train.navigation.destination != station2) continue;
                DiscoveredPath preferredPath = train.runtime.startCurrentInstruction();
                train.navigation.startNavigation(preferredPath != null ? preferredPath : train.navigation.findPathTo(station2, Double.MAX_VALUE));
            }
        }
        return true;
    }

    public boolean exitAssemblyMode() {
        if (!this.isAssembling()) {
            return false;
        }
        this.cancelAssembly();
        class_2680 newState = (class_2680)this.method_11010().method_11657((class_2769)StationBlock.ASSEMBLING, (Comparable)Boolean.valueOf(false));
        this.field_11863.method_8652(this.method_11016(), newState, 3);
        this.refreshBlockState();
        return this.updateStationState(station -> {
            station.assembling = false;
        });
    }

    public boolean tryDisassembleTrain(@Nullable class_3222 sender) {
        GlobalStation station = this.getStation();
        if (station == null) {
            return false;
        }
        Train train = station.getPresentTrain();
        if (train == null) {
            return false;
        }
        class_2338 trackPosition = this.edgePoint.getGlobalPosition();
        if (!train.disassemble(this.getAssemblyDirection(), trackPosition.method_10084())) {
            return false;
        }
        this.dropSchedule(sender);
        return true;
    }

    public boolean isAssembling() {
        class_2680 state = this.method_11010();
        return state.method_28498((class_2769)StationBlock.ASSEMBLING) && (Boolean)state.method_11654((class_2769)StationBlock.ASSEMBLING) != false;
    }

    public boolean tryEnterAssemblyMode() {
        if (!this.edgePoint.hasValidTrack()) {
            return false;
        }
        class_2338 targetPosition = this.edgePoint.getGlobalPosition();
        class_2680 trackState = this.edgePoint.getTrackBlockState();
        ITrackBlock track = this.edgePoint.getTrack();
        class_243 trackAxis = track.getTrackAxes((class_1922)this.field_11863, targetPosition, trackState).get(0);
        boolean axisFound = false;
        for (class_2350.class_2351 axis : Iterate.axes) {
            if (trackAxis.method_18043(axis) == 0.0) continue;
            if (axisFound) {
                return false;
            }
            axisFound = true;
        }
        return true;
    }

    public void dropSchedule(@Nullable class_3222 sender) {
        GlobalStation station = this.getStation();
        if (station == null) {
            return;
        }
        Train train = station.getPresentTrain();
        if (train == null) {
            return;
        }
        class_1799 schedule = train.runtime.returnSchedule();
        if (schedule.method_7960()) {
            return;
        }
        if (sender != null && sender.method_6047().method_7960()) {
            sender.method_31548().method_7398(schedule);
            return;
        }
        class_243 v = VecHelper.getCenterOf((class_2382)this.method_11016());
        class_1542 itemEntity = new class_1542(this.method_10997(), v.field_1352, v.field_1351, v.field_1350, schedule);
        itemEntity.method_18799(class_243.field_1353);
        this.method_10997().method_8649((class_1297)itemEntity);
    }

    private boolean updateStationState(Consumer<GlobalStation> updateState) {
        GlobalStation station = this.getStation();
        TrackGraphLocation graphLocation = this.edgePoint.determineGraphLocation();
        if (station == null || graphLocation == null) {
            return false;
        }
        updateState.accept(station);
        Create.RAILWAYS.sync.pointAdded(graphLocation.graph, station);
        Create.RAILWAYS.markTracksDirty();
        return true;
    }

    public void refreshAssemblyInfo() {
        GlobalStation station;
        if (!this.edgePoint.hasValidTrack()) {
            return;
        }
        if (!(this.isVirtual() || (station = this.getStation()) != null && station.getPresentTrain() == null)) {
            return;
        }
        int prevLength = this.assemblyLength;
        class_2338 targetPosition = this.edgePoint.getGlobalPosition();
        class_2680 trackState = this.edgePoint.getTrackBlockState();
        ITrackBlock track = this.edgePoint.getTrack();
        this.getAssemblyDirection();
        class_2338.class_2339 currentPos = targetPosition.method_25503();
        currentPos.method_10098(this.assemblyDirection);
        class_2338 bogeyOffset = class_2338.method_49638((class_2374)track.getUpNormal((class_1922)this.field_11863, targetPosition, trackState));
        int MAX_LENGTH = (Integer)AllConfigs.server().trains.maxAssemblyLength.get();
        int MAX_BOGEY_COUNT = (Integer)AllConfigs.server().trains.maxBogeyCount.get();
        int bogeyIndex = 0;
        int maxBogeyCount = MAX_BOGEY_COUNT;
        if (this.bogeyLocations == null) {
            this.bogeyLocations = new int[maxBogeyCount];
        }
        if (this.bogeyTypes == null) {
            this.bogeyTypes = new AbstractBogeyBlock[maxBogeyCount];
        }
        if (this.upsideDownBogeys == null) {
            this.upsideDownBogeys = new boolean[maxBogeyCount];
        }
        Arrays.fill(this.bogeyLocations, -1);
        Arrays.fill(this.bogeyTypes, null);
        Arrays.fill(this.upsideDownBogeys, false);
        for (int i = 0; i < MAX_LENGTH; ++i) {
            if (i == MAX_LENGTH - 1) {
                this.assemblyLength = i;
                break;
            }
            if (!track.trackEquals(trackState, this.field_11863.method_8320((class_2338)currentPos))) {
                this.assemblyLength = Math.max(0, i - 1);
                break;
            }
            class_2680 potentialBogeyState = this.field_11863.method_8320(bogeyOffset.method_10081((class_2382)currentPos));
            class_2338 upsideDownBogeyOffset = new class_2338(bogeyOffset.method_10263(), bogeyOffset.method_10264() * -1, bogeyOffset.method_10260());
            if (bogeyIndex < this.bogeyLocations.length) {
                AbstractBogeyBlock bogey;
                class_2248 class_22482 = potentialBogeyState.method_26204();
                if (class_22482 instanceof AbstractBogeyBlock && !(bogey = (AbstractBogeyBlock)class_22482).isUpsideDown(potentialBogeyState)) {
                    this.bogeyTypes[bogeyIndex] = bogey;
                    this.bogeyLocations[bogeyIndex] = i;
                    this.upsideDownBogeys[bogeyIndex] = false;
                    ++bogeyIndex;
                } else {
                    AbstractBogeyBlock bogey2;
                    potentialBogeyState = this.field_11863.method_8320(upsideDownBogeyOffset.method_10081((class_2382)currentPos));
                    class_22482 = potentialBogeyState.method_26204();
                    if (class_22482 instanceof AbstractBogeyBlock && (bogey2 = (AbstractBogeyBlock)class_22482).isUpsideDown(potentialBogeyState)) {
                        this.bogeyTypes[bogeyIndex] = bogey2;
                        this.bogeyLocations[bogeyIndex] = i;
                        this.upsideDownBogeys[bogeyIndex] = true;
                        ++bogeyIndex;
                    }
                }
            }
            currentPos.method_10098(this.assemblyDirection);
        }
        this.bogeyCount = bogeyIndex;
        if (this.field_11863.field_9236) {
            return;
        }
        if (prevLength == this.assemblyLength) {
            return;
        }
        if (this.isVirtual()) {
            return;
        }
        Map<class_2338, class_3341> map = assemblyAreas.get((class_1936)this.field_11863);
        class_2338 startPosition = targetPosition.method_10093(this.assemblyDirection);
        class_2338 trackEnd = startPosition.method_10079(this.assemblyDirection, this.assemblyLength - 1);
        map.put(this.field_11867, class_3341.method_34390((class_2382)startPosition, (class_2382)trackEnd));
    }

    public boolean updateName(String name) {
        if (!this.updateStationState(station -> {
            station.name = name;
        })) {
            return false;
        }
        this.notifyUpdate();
        return true;
    }

    public boolean isValidBogeyOffset(int i) {
        if ((i < 3 || this.bogeyCount == 0) && i != 0) {
            return false;
        }
        for (int j : this.bogeyLocations) {
            if (j == -1) break;
            if (i < j - 2 || i > j + 2) continue;
            return false;
        }
        return true;
    }

    public class_2350 getAssemblyDirection() {
        if (this.assemblyDirection != null) {
            return this.assemblyDirection;
        }
        if (!this.edgePoint.hasValidTrack()) {
            return null;
        }
        class_2338 targetPosition = this.edgePoint.getGlobalPosition();
        class_2680 trackState = this.edgePoint.getTrackBlockState();
        ITrackBlock track = this.edgePoint.getTrack();
        class_2350.class_2352 axisDirection = this.edgePoint.getTargetDirection();
        class_243 axis = track.getTrackAxes((class_1922)this.field_11863, targetPosition, trackState).get(0).method_1029().method_1021((double)axisDirection.method_10181());
        this.assemblyDirection = class_2350.method_10142((double)axis.field_1352, (double)axis.field_1351, (double)axis.field_1350);
        return this.assemblyDirection;
    }

    @Override
    public void remove() {
        assemblyAreas.get((class_1936)this.field_11863).remove(this.field_11867);
        super.remove();
    }

    public void assemble(UUID playerUUID) {
        int pointIndex;
        int loc;
        this.refreshAssemblyInfo();
        if (this.bogeyLocations == null) {
            return;
        }
        if (this.bogeyLocations[0] != 0) {
            this.exception(new AssemblyException((class_2561)Lang.translateDirect("train_assembly.frontmost_bogey_at_station", new Object[0])), -1);
            return;
        }
        if (!this.edgePoint.hasValidTrack()) {
            return;
        }
        class_2338 trackPosition = this.edgePoint.getGlobalPosition();
        class_2680 trackState = this.edgePoint.getTrackBlockState();
        ITrackBlock track = this.edgePoint.getTrack();
        class_2338 bogeyOffset = class_2338.method_49638((class_2374)track.getUpNormal((class_1922)this.field_11863, trackPosition, trackState));
        TrackNodeLocation location = null;
        class_243 centre = class_243.method_24955((class_2382)trackPosition).method_1031(0.0, track.getElevationAtCenter((class_1922)this.field_11863, trackPosition, trackState), 0.0);
        Collection<TrackNodeLocation.DiscoveredLocation> ends = track.getConnected((class_1922)this.field_11863, trackPosition, trackState, true, null);
        class_243 targetOffset = class_243.method_24954((class_2382)this.assemblyDirection.method_10163());
        for (TrackNodeLocation.DiscoveredLocation end : ends) {
            if (!class_3532.method_20390((double)0.0, (double)targetOffset.method_1025(end.getLocation().method_1020(centre).method_1029()))) continue;
            location = end;
        }
        if (location == null) {
            return;
        }
        ArrayList<Double> pointOffsets = new ArrayList<Double>();
        int iPrevious = -100;
        for (int i = 0; i < this.bogeyLocations.length && (loc = this.bogeyLocations[i]) != -1; ++i) {
            if (loc - iPrevious < 3) {
                this.exception(new AssemblyException((class_2561)Lang.translateDirect("train_assembly.bogeys_too_close", i, i + 1)), -1);
                return;
            }
            double bogeySize = this.bogeyTypes[i].getWheelPointSpacing();
            pointOffsets.add((double)loc + 0.5 - bogeySize / 2.0);
            pointOffsets.add((double)loc + 0.5 + bogeySize / 2.0);
            iPrevious = loc;
        }
        ArrayList<TravellingPoint> points = new ArrayList<TravellingPoint>();
        class_243 directionVec = class_243.method_24954((class_2382)this.assemblyDirection.method_10163());
        TrackGraph graph = null;
        TrackNode secondNode = null;
        for (int j = 0; j < this.assemblyLength * 2 + 40; ++j) {
            double offset;
            TrackNode node;
            double i = (double)j / 2.0;
            if (points.size() == pointOffsets.size()) break;
            TrackNodeLocation.DiscoveredLocation currentLocation = location;
            location = new TrackNodeLocation(location.getLocation().method_1019(directionVec.method_1021(0.5))).in(location.dimension);
            if (graph == null) {
                graph = Create.RAILWAYS.getGraph((class_1936)this.field_11863, currentLocation);
            }
            if (graph == null || (node = graph.locateNode(currentLocation)) == null) continue;
            for (pointIndex = points.size(); pointIndex < pointOffsets.size() && !((offset = ((Double)pointOffsets.get(pointIndex)).doubleValue()) > i); ++pointIndex) {
                double positionOnEdge = i - offset;
                Map<TrackNode, TrackEdge> connectionsFromNode = graph.getConnectionsFrom(node);
                if (secondNode == null) {
                    for (Map.Entry<TrackNode, TrackEdge> entry : connectionsFromNode.entrySet()) {
                        class_243 edgeDirection;
                        TrackEdge edge = entry.getValue();
                        TrackNode otherNode = entry.getKey();
                        if (edge.isTurn() || !class_3532.method_20390((double)(edgeDirection = edge.getDirection(true)).method_1029().method_1026(directionVec), (double)-1.0)) continue;
                        secondNode = otherNode;
                    }
                }
                if (secondNode == null) {
                    Create.LOGGER.warn("Cannot assemble: No valid starting node found");
                    return;
                }
                TrackEdge edge = connectionsFromNode.get(secondNode);
                if (edge == null) {
                    Create.LOGGER.warn("Cannot assemble: Missing graph edge");
                    return;
                }
                points.add(new TravellingPoint(node, secondNode, edge, positionOnEdge, false));
            }
            secondNode = node;
        }
        if (points.size() != pointOffsets.size()) {
            Create.LOGGER.warn("Cannot assemble: Not all Points created");
            return;
        }
        if (points.size() == 0) {
            this.exception(new AssemblyException((class_2561)Lang.translateDirect("train_assembly.no_bogeys", new Object[0])), -1);
            return;
        }
        ArrayList<CarriageContraption> contraptions = new ArrayList<CarriageContraption>();
        ArrayList<Carriage> carriages = new ArrayList<Carriage>();
        ArrayList<Integer> spacing = new ArrayList<Integer>();
        boolean atLeastOneForwardControls = false;
        for (int bogeyIndex = 0; bogeyIndex < this.bogeyCount; ++bogeyIndex) {
            pointIndex = bogeyIndex * 2;
            if (bogeyIndex > 0) {
                spacing.add(this.bogeyLocations[bogeyIndex] - this.bogeyLocations[bogeyIndex - 1]);
            }
            CarriageContraption contraption = new CarriageContraption(this.assemblyDirection);
            class_2338 bogeyPosOffset = trackPosition.method_10081((class_2382)bogeyOffset);
            class_2338 upsideDownBogeyPosOffset = trackPosition.method_10081((class_2382)new class_2338(bogeyOffset.method_10263(), bogeyOffset.method_10264() * -1, bogeyOffset.method_10260()));
            try {
                int offset = this.bogeyLocations[bogeyIndex] + 1;
                boolean success = contraption.assemble(this.field_11863, this.upsideDownBogeys[bogeyIndex] ? upsideDownBogeyPosOffset.method_10079(this.assemblyDirection, offset) : bogeyPosOffset.method_10079(this.assemblyDirection, offset));
                atLeastOneForwardControls |= contraption.hasForwardControls();
                contraption.setSoundQueueOffset(offset);
                if (!success) {
                    this.exception(new AssemblyException((class_2561)Lang.translateDirect("train_assembly.nothing_attached", bogeyIndex + 1)), -1);
                    return;
                }
            }
            catch (AssemblyException e) {
                this.exception(e, contraptions.size() + 1);
                return;
            }
            AbstractBogeyBlock<?> typeOfFirstBogey = this.bogeyTypes[bogeyIndex];
            boolean firstBogeyIsUpsideDown = this.upsideDownBogeys[bogeyIndex];
            class_2338 firstBogeyPos = contraption.anchor;
            AbstractBogeyBlockEntity firstBogeyBlockEntity = (AbstractBogeyBlockEntity)this.field_11863.method_8321(firstBogeyPos);
            CarriageBogey firstBogey = new CarriageBogey(typeOfFirstBogey, firstBogeyIsUpsideDown, firstBogeyBlockEntity.getBogeyData(), (TravellingPoint)points.get(pointIndex), (TravellingPoint)points.get(pointIndex + 1));
            CarriageBogey secondBogey = null;
            class_2338 secondBogeyPos = contraption.getSecondBogeyPos();
            int bogeySpacing = 0;
            if (secondBogeyPos != null) {
                if (bogeyIndex == this.bogeyCount - 1 || !secondBogeyPos.equals((Object)(this.upsideDownBogeys[bogeyIndex + 1] ? upsideDownBogeyPosOffset : bogeyPosOffset).method_10079(this.assemblyDirection, this.bogeyLocations[bogeyIndex + 1] + 1))) {
                    this.exception(new AssemblyException((class_2561)Lang.translateDirect("train_assembly.not_connected_in_order", new Object[0])), contraptions.size() + 1);
                    return;
                }
                AbstractBogeyBlockEntity secondBogeyBlockEntity = (AbstractBogeyBlockEntity)this.field_11863.method_8321(secondBogeyPos);
                bogeySpacing = this.bogeyLocations[bogeyIndex + 1] - this.bogeyLocations[bogeyIndex];
                secondBogey = new CarriageBogey(this.bogeyTypes[bogeyIndex + 1], this.upsideDownBogeys[bogeyIndex + 1], secondBogeyBlockEntity.getBogeyData(), (TravellingPoint)points.get(pointIndex + 2), (TravellingPoint)points.get(pointIndex + 3));
                ++bogeyIndex;
            } else if (!typeOfFirstBogey.allowsSingleBogeyCarriage()) {
                this.exception(new AssemblyException((class_2561)Lang.translateDirect("train_assembly.single_bogey_carriage", new Object[0])), contraptions.size() + 1);
                return;
            }
            contraptions.add(contraption);
            carriages.add(new Carriage(firstBogey, secondBogey, bogeySpacing));
        }
        if (!atLeastOneForwardControls) {
            this.exception(new AssemblyException((class_2561)Lang.translateDirect("train_assembly.no_controls", new Object[0])), -1);
            return;
        }
        for (CarriageContraption contraption : contraptions) {
            contraption.removeBlocksFromWorld(this.field_11863, class_2338.field_10980);
            contraption.expandBoundsAroundAxis(class_2350.class_2351.field_11052);
        }
        Train train = new Train(UUID.randomUUID(), playerUUID, graph, carriages, spacing, contraptions.stream().anyMatch(CarriageContraption::hasBackwardControls));
        if (this.lastDisassembledTrainName != null) {
            train.name = this.lastDisassembledTrainName;
            this.lastDisassembledTrainName = null;
        }
        for (int i = 0; i < contraptions.size(); ++i) {
            CarriageContraption contraption = (CarriageContraption)contraptions.get(i);
            Carriage carriage = (Carriage)carriages.get(i);
            carriage.setContraption(this.field_11863, contraption);
            if (!contraption.containsBlockBreakers()) continue;
            this.award(AllAdvancements.CONTRAPTION_ACTORS);
        }
        GlobalStation station = this.getStation();
        if (station != null) {
            train.setCurrentStation(station);
            station.reserveFor(train);
        }
        train.collectInitiallyOccupiedSignalBlocks();
        Create.RAILWAYS.addTrain(train);
        AllPackets.getChannel().sendToClientsInServer((S2CPacket)new TrainPacket(train, true), this.field_11863.method_8503());
        this.clearException();
        this.award(AllAdvancements.TRAIN);
        if (contraptions.size() >= 6) {
            this.award(AllAdvancements.LONG_TRAIN);
        }
    }

    public void cancelAssembly() {
        this.assemblyLength = 0;
        assemblyAreas.get((class_1936)this.field_11863).remove(this.field_11867);
        this.clearException();
    }

    private void clearException() {
        this.exception(null, -1);
    }

    private void exception(AssemblyException exception, int carriage) {
        this.failedCarriageIndex = carriage;
        this.lastException = exception;
        this.sendData();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public class_238 getRenderBoundingBox() {
        if (this.isAssembling()) {
            return INFINITE_EXTENT_AABB;
        }
        return super.getRenderBoundingBox();
    }

    @Override
    protected class_238 createRenderBoundingBox() {
        return new class_238(this.field_11867, this.edgePoint.getGlobalPosition()).method_1014(2.0);
    }

    public class_1799 getAutoSchedule() {
        return this.depotBehaviour.getHeldItemStack();
    }

    @Nullable
    public Storage<ItemVariant> getItemStorage(@Nullable class_2350 face) {
        return this.depotBehaviour.itemHandler;
    }

    private void applyAutoSchedule() {
        class_1799 stack = this.getAutoSchedule();
        if (!AllItems.SCHEDULE.isIn(stack)) {
            return;
        }
        Schedule schedule = ScheduleItem.getSchedule(stack);
        if (schedule == null || schedule.entries.isEmpty()) {
            return;
        }
        GlobalStation station = this.getStation();
        if (station == null) {
            return;
        }
        Train imminentTrain = station.getImminentTrain();
        if (imminentTrain == null || imminentTrain.getCurrentStation() != station) {
            return;
        }
        this.award(AllAdvancements.CONDUCTOR);
        imminentTrain.runtime.setSchedule(schedule, true);
        AllSoundEvents.CONFIRM.playOnServer(this.field_11863, (class_2382)this.field_11867, 1.0f, 1.0f);
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 server = (class_3218)class_19372;
        class_243 v = class_243.method_24955((class_2382)this.field_11867.method_10084());
        server.method_14199((class_2394)class_2398.field_11211, v.field_1352, v.field_1351, v.field_1350, 8, 0.35, 0.05, 0.35, 1.0);
        server.method_14199((class_2394)class_2398.field_11207, v.field_1352, v.field_1351 + 0.25, v.field_1350, 10, 0.05, 1.0, 0.05, (double)0.005f);
    }

    public boolean resolveFlagAngle() {
        if (this.flagYRot != -1) {
            return true;
        }
        class_2680 target = this.edgePoint.getTrackBlockState();
        class_2248 class_22482 = target.method_26204();
        if (!(class_22482 instanceof ITrackBlock)) {
            return false;
        }
        ITrackBlock def = (ITrackBlock)class_22482;
        class_243 axis = null;
        class_2338 trackPos = this.edgePoint.getGlobalPosition();
        for (class_243 vec3 : def.getTrackAxes((class_1922)this.field_11863, trackPos, target)) {
            axis = vec3.method_1021((double)this.edgePoint.getTargetDirection().method_10181());
        }
        if (axis == null) {
            return false;
        }
        class_2350 nearest = class_2350.method_10142((double)axis.field_1352, (double)0.0, (double)axis.field_1350);
        this.flagYRot = (int)(-nearest.method_10144() - 90.0f);
        class_243 diff = class_243.method_24954((class_2382)trackPos.method_10059((class_2382)this.field_11867)).method_18805(1.0, 0.0, 1.0);
        if (diff.method_1027() == 0.0) {
            return true;
        }
        this.flagFlipped = diff.method_1026(class_243.method_24954((class_2382)nearest.method_10170().method_10163())) > 0.0;
        return true;
    }

    @Override
    public void transform(StructureTransform transform) {
        this.edgePoint.transform(transform);
    }
}

