/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.bogey;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_2960;

public class BogeySizes {
    private static final Collection<BogeySize> BOGEY_SIZES = new HashSet<BogeySize>();
    public static final BogeySize SMALL = new BogeySize("create", "small", 0.40625f);
    public static final BogeySize LARGE = new BogeySize("create", "large", 0.78125f);

    public static BogeySize addSize(String modId, String name, float size) {
        class_2960 location = new class_2960(modId, name);
        return BogeySizes.addSize(location, size);
    }

    public static BogeySize addSize(class_2960 location, float size) {
        BogeySize customSize = new BogeySize(location, size);
        BOGEY_SIZES.add(customSize);
        return customSize;
    }

    public static List<BogeySize> getAllSizesSmallToLarge() {
        return BOGEY_SIZES.stream().sorted(Comparator.comparing(BogeySize::wheelRadius)).collect(Collectors.toList());
    }

    public static List<BogeySize> getAllSizesLargeToSmall() {
        List<BogeySize> sizes = BogeySizes.getAllSizesSmallToLarge();
        Collections.reverse(sizes);
        return sizes;
    }

    public static int count() {
        return BOGEY_SIZES.size();
    }

    public static void init() {
    }

    static {
        BOGEY_SIZES.add(SMALL);
        BOGEY_SIZES.add(LARGE);
    }

    public record BogeySize(class_2960 location, float wheelRadius) {
        public BogeySize(String modId, String name, float wheelRadius) {
            this(new class_2960(modId, name), wheelRadius);
        }

        public BogeySize increment() {
            List<BogeySize> values = BogeySizes.getAllSizesSmallToLarge();
            int ordinal = values.indexOf(this);
            return values.get((ordinal + 1) % values.size());
        }

        public boolean is(BogeySize size) {
            return size.location == this.location;
        }
    }
}

