/*
 * Decompiled with CFR 0.152.
 */
package dev.jeryn.angels.util;

import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.jeryn.angels.common.entity.angel.AbstractWeepingAngel;
import dev.jeryn.angels.util.fabric.ViewUtilImpl;
import java.util.function.Predicate;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_2680;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;

public class ViewUtil {
    private static final float headSize = 0.15f;

    public static boolean isInFrontOfEntity(class_1309 entity, class_1297 target, boolean vr) {
        class_243 vecTargetsPos = target.method_19538();
        class_243 vecLook = entity.method_5720();
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (vr) {
                vecLook = ViewUtil.manipulateVrRotation(player, entity.method_5720());
            }
        }
        class_243 vecFinal = vecTargetsPos.method_1035(new class_243(entity.method_23317(), entity.method_23318(), entity.method_23321())).method_1029();
        vecFinal = new class_243(vecFinal.field_1352, 0.0, vecFinal.field_1350);
        return vecFinal.method_1026(vecLook) < 0.0;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static class_243 manipulateVrRotation(class_1657 player, class_243 vec3) {
        void var1_1;
        return ViewUtilImpl.manipulateVrRotation(player, (class_243)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static class_243 manipulateVrPosition(class_1657 player, class_243 vec3) {
        void var1_1;
        return ViewUtilImpl.manipulateVrPosition(player, (class_243)var1_1);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isVrPlayer(class_1657 player) {
        return ViewUtilImpl.isVrPlayer(player);
    }

    public static boolean isInSight(class_1309 livingBase, AbstractWeepingAngel angel) {
        if (ViewUtil.isPlayerBlind(livingBase)) {
            return false;
        }
        if (ViewUtil.viewBlocked(livingBase, (class_1309)angel)) {
            return false;
        }
        if (livingBase instanceof class_1657) {
            class_1657 player = (class_1657)livingBase;
            return ViewUtil.isInFrontOfEntity(livingBase, (class_1297)angel, ViewUtil.isVrPlayer(player));
        }
        return ViewUtil.isInFrontOfEntity(livingBase, (class_1297)angel, false);
    }

    public static boolean viewBlocked(class_1309 viewer, class_1309 angel) {
        class_238 viewerBoundBox = viewer.method_5829();
        class_238 angelBoundingBox = angel.method_5829();
        class_243[] viewerPoints = new class_243[]{new class_243(viewerBoundBox.field_1323, viewerBoundBox.field_1322, viewerBoundBox.field_1321), new class_243(viewerBoundBox.field_1323, viewerBoundBox.field_1322, viewerBoundBox.field_1324), new class_243(viewerBoundBox.field_1323, viewerBoundBox.field_1325, viewerBoundBox.field_1321), new class_243(viewerBoundBox.field_1323, viewerBoundBox.field_1325, viewerBoundBox.field_1324), new class_243(viewerBoundBox.field_1320, viewerBoundBox.field_1325, viewerBoundBox.field_1321), new class_243(viewerBoundBox.field_1320, viewerBoundBox.field_1325, viewerBoundBox.field_1324), new class_243(viewerBoundBox.field_1320, viewerBoundBox.field_1322, viewerBoundBox.field_1324), new class_243(viewerBoundBox.field_1320, viewerBoundBox.field_1322, viewerBoundBox.field_1321)};
        if (viewer instanceof class_1657) {
            class_1657 player = (class_1657)viewer;
            class_243 pos2 = new class_243(viewer.method_23317(), viewer.method_23318() + (double)1.62f, viewer.method_23321());
            if (ViewUtil.isVrPlayer(player)) {
                pos2 = ViewUtil.manipulateVrPosition(player, pos2);
            }
            viewerPoints[0] = pos2.method_1031((double)-0.15f, (double)-0.15f, (double)-0.15f);
            viewerPoints[1] = pos2.method_1031((double)-0.15f, (double)-0.15f, (double)0.15f);
            viewerPoints[2] = pos2.method_1031((double)-0.15f, (double)0.15f, (double)-0.15f);
            viewerPoints[3] = pos2.method_1031((double)-0.15f, (double)0.15f, (double)0.15f);
            viewerPoints[4] = pos2.method_1031((double)0.15f, (double)0.15f, (double)-0.15f);
            viewerPoints[5] = pos2.method_1031((double)0.15f, (double)0.15f, (double)0.15f);
            viewerPoints[6] = pos2.method_1031((double)0.15f, (double)-0.15f, (double)0.15f);
            viewerPoints[7] = pos2.method_1031((double)0.15f, (double)-0.15f, (double)-0.15f);
        }
        class_243[] angelPoints = new class_243[]{new class_243(angelBoundingBox.field_1323, angelBoundingBox.field_1322, angelBoundingBox.field_1321), new class_243(angelBoundingBox.field_1323, angelBoundingBox.field_1322, angelBoundingBox.field_1324), new class_243(angelBoundingBox.field_1323, angelBoundingBox.field_1325, angelBoundingBox.field_1321), new class_243(angelBoundingBox.field_1323, angelBoundingBox.field_1325, angelBoundingBox.field_1324), new class_243(angelBoundingBox.field_1320, angelBoundingBox.field_1325, angelBoundingBox.field_1321), new class_243(angelBoundingBox.field_1320, angelBoundingBox.field_1325, angelBoundingBox.field_1324), new class_243(angelBoundingBox.field_1320, angelBoundingBox.field_1322, angelBoundingBox.field_1324), new class_243(angelBoundingBox.field_1320, angelBoundingBox.field_1322, angelBoundingBox.field_1321)};
        for (int i = 0; i < viewerPoints.length; ++i) {
            if (viewer.method_37908().method_17742(new class_3959(viewerPoints[i], angelPoints[i], class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)viewer)).method_17783() == class_239.class_240.field_1333) {
                return false;
            }
            if (ViewUtil.rayTraceBlocks(viewer, viewer.method_37908(), viewerPoints[i], angelPoints[i], pos -> {
                class_2680 state = viewer.method_37908().method_8320(pos);
                return !ViewUtil.canSeeThrough(state, viewer.method_37908(), pos);
            }) != null) continue;
            return false;
        }
        if (angel.field_6012 % 1200 == 0 && angel.method_5739((class_1297)viewer) < 15.0f) {
            viewer.method_6092(new class_1293(class_1294.field_5919, 15));
        }
        return true;
    }

    public static boolean isDarkForPlayer(AbstractWeepingAngel angel, class_1309 living) {
        return !living.method_6059(class_1294.field_5925) && angel.method_37908().method_8317(angel.method_24515()) <= 0 && !angel.method_37908().method_8597().comp_643();
    }

    public static boolean isPlayerBlind(class_1309 living) {
        return living.method_6059(class_1294.field_5919);
    }

    private static class_239 rayTraceBlocks(class_1309 livingEntity, class_1937 world, class_243 startVec, class_243 endVec, Predicate<class_2338> stopOn) {
        class_3965 result;
        if (ViewUtil.hasNaN(startVec) || ViewUtil.hasNaN(endVec)) {
            return null;
        }
        int startX = class_3532.method_15357((double)startVec.field_1352);
        int startY = class_3532.method_15357((double)startVec.field_1351);
        int startZ = class_3532.method_15357((double)startVec.field_1350);
        int endX = class_3532.method_15357((double)endVec.field_1352);
        int endY = class_3532.method_15357((double)endVec.field_1351);
        int endZ = class_3532.method_15357((double)endVec.field_1350);
        class_2338 currentPos = new class_2338(startX, startY, startZ);
        if (stopOn.test(currentPos) && (result = world.method_17742(new class_3959(startVec, endVec, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)livingEntity))) != null) {
            return result;
        }
        int maxIterations = 200;
        while (maxIterations-- >= 0) {
            class_3965 result2;
            class_2350 direction;
            double ratioZ;
            if (startX == endX && startY == endY && startZ == endZ) {
                return null;
            }
            boolean stepX = true;
            boolean stepY = true;
            boolean stepZ = true;
            double nextX = Double.POSITIVE_INFINITY;
            double nextY = Double.POSITIVE_INFINITY;
            double nextZ = Double.POSITIVE_INFINITY;
            if (endX > startX) {
                nextX = (double)startX + 1.0;
            } else if (endX < startX) {
                nextX = (double)startX + 0.0;
            } else {
                stepX = false;
            }
            if (endY > startY) {
                nextY = (double)startY + 1.0;
            } else if (endY < startY) {
                nextY = (double)startY + 0.0;
            } else {
                stepY = false;
            }
            if (endZ > startZ) {
                nextZ = (double)startZ + 1.0;
            } else if (endZ < startZ) {
                nextZ = (double)startZ + 0.0;
            } else {
                stepZ = false;
            }
            double deltaX = endVec.field_1352 - startVec.field_1352;
            double deltaY = endVec.field_1351 - startVec.field_1351;
            double deltaZ = endVec.field_1350 - startVec.field_1350;
            double ratioX = stepX ? (nextX - startVec.field_1352) / deltaX : Double.POSITIVE_INFINITY;
            double ratioY = stepY ? (nextY - startVec.field_1351) / deltaY : Double.POSITIVE_INFINITY;
            double d = ratioZ = stepZ ? (nextZ - startVec.field_1350) / deltaZ : Double.POSITIVE_INFINITY;
            if (ratioX == -0.0) {
                ratioX = -1.0E-4;
            }
            if (ratioY == -0.0) {
                ratioY = -1.0E-4;
            }
            if (ratioZ == -0.0) {
                ratioZ = -1.0E-4;
            }
            if (ratioX < ratioY && ratioX < ratioZ) {
                direction = endX > startX ? class_2350.field_11039 : class_2350.field_11034;
                startVec = new class_243(nextX, startVec.field_1351 + deltaY * ratioX, startVec.field_1350 + deltaZ * ratioX);
            } else if (ratioY < ratioZ) {
                direction = endY > startY ? class_2350.field_11033 : class_2350.field_11036;
                startVec = new class_243(startVec.field_1352 + deltaX * ratioY, nextY, startVec.field_1350 + deltaZ * ratioY);
            } else {
                direction = endZ > startZ ? class_2350.field_11043 : class_2350.field_11035;
                startVec = new class_243(startVec.field_1352 + deltaX * ratioZ, startVec.field_1351 + deltaY * ratioZ, nextZ);
            }
            if (!stopOn.test(currentPos = new class_2338(startX = class_3532.method_15357((double)startVec.field_1352) - (direction == class_2350.field_11034 ? 1 : 0), startY = class_3532.method_15357((double)startVec.field_1351) - (direction == class_2350.field_11036 ? 1 : 0), startZ = class_3532.method_15357((double)startVec.field_1350) - (direction == class_2350.field_11035 ? 1 : 0))) || (result2 = world.method_17742(new class_3959(startVec, endVec, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)livingEntity))) == null) continue;
            return result2;
        }
        return null;
    }

    private static boolean hasNaN(class_243 vec) {
        return Double.isNaN(vec.field_1352) || Double.isNaN(vec.field_1351) || Double.isNaN(vec.field_1350);
    }

    public static boolean canSeeThrough(class_2680 blockState, class_1937 world, class_2338 pos) {
        if (!blockState.method_26225() || !blockState.method_26216((class_1922)world, pos)) {
            return true;
        }
        class_2248 block = blockState.method_26204();
        if (block instanceof class_2323) {
            return blockState.method_11654((class_2769)class_2323.field_10946) == class_2756.field_12609;
        }
        if (!block.method_9564().method_26225()) {
            return true;
        }
        return blockState.method_26220((class_1922)world, pos) == class_259.method_1073();
    }
}

