/*
 * Decompiled with CFR 0.152.
 */
package dev.jeryn.angels.util;

import com.google.common.collect.Lists;
import dev.jeryn.angels.WAConfiguration;
import dev.jeryn.angels.WeepingAngels;
import dev.jeryn.angels.common.WASounds;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_14;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2767;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3230;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7;
import net.minecraft.server.MinecraftServer;

public class Teleporter {
    public static class_3218 getRandomDimension(class_5819 rand, class_3218 serverLevel) {
        MinecraftServer server = serverLevel.method_8503();
        Iterable dimensions = server.method_3738();
        ArrayList allowedDimensions = Lists.newArrayList((Iterable)dimensions);
        for (class_3218 dimension : dimensions) {
            for (String dimName : (List)WAConfiguration.CONFIG.bannedDimensions.get()) {
                if (!dimension.method_27983().method_29177().toString().equalsIgnoreCase(dimName)) continue;
                allowedDimensions.remove(dimension);
            }
        }
        allowedDimensions.remove(server.method_3847(class_1937.field_25180));
        return (class_3218)allowedDimensions.get(rand.method_43048(allowedDimensions.size()));
    }

    public static class_2338 findClosestValidPosition(class_3218 level, class_2338 position) {
        class_1923 chunkPos = level.method_22350(position).method_12004();
        int maxBuildHeight = level.method_31600();
        int minHeight = level.method_31607();
        ArrayList<class_2338> solutionsInRow = new ArrayList<class_2338>();
        level.method_17988(chunkPos.field_9181, chunkPos.field_9180, true);
        class_2338 closest = class_2338.field_10980;
        if (Teleporter.canPlaceTardis(level, position) && Teleporter.isExitPositionSafe(level, position)) {
            solutionsInRow.add(position);
        }
        if (!solutionsInRow.isEmpty()) {
            closest = position;
        } else {
            List<class_2338> nextValidLocations = Teleporter.findValidLocationInColumn(level, position, minHeight, maxBuildHeight);
            if (!nextValidLocations.isEmpty()) {
                solutionsInRow.addAll(nextValidLocations);
            } else {
                List<class_2338> surroundingPositionsSameYLevel = Teleporter.getBlockPosInRadius(position, 1, true, false);
                for (class_2338 directionOffset : surroundingPositionsSameYLevel) {
                    class_2338 nextLocation = directionOffset;
                    if (!Teleporter.canPlaceTardis(level, nextLocation) || !Teleporter.isExitPositionSafe(level, nextLocation)) continue;
                    solutionsInRow.add(nextLocation);
                }
                if (solutionsInRow.isEmpty()) {
                    List<class_2338> surroundingPositionsForColumn = Teleporter.getBlockPosInRadius(position, 6, true, true);
                    for (class_2338 pos : surroundingPositionsForColumn) {
                        List<class_2338> surroundingColumn = Teleporter.findValidLocationInColumn(level, pos, minHeight, maxBuildHeight);
                        if (surroundingColumn.isEmpty()) continue;
                        solutionsInRow.addAll(surroundingColumn);
                    }
                }
            }
            closest = Teleporter.findClosestValidPositionFromTarget(solutionsInRow, position);
        }
        level.method_17988(chunkPos.field_9181, chunkPos.field_9180, false);
        return closest;
    }

    public static List<class_2338> getBlockPosInRadius(class_2338 referencePoint, int radius, boolean interCardinal, boolean includeReferencePoint) {
        ArrayList<class_2338> posList = new ArrayList<class_2338>();
        ArrayList horizontalDirections = new ArrayList();
        horizontalDirections.addAll(class_2350.class_2353.field_11062.method_29716().toList());
        for (class_2350 dir : horizontalDirections) {
            class_2338 offsettedPos = referencePoint.method_10079(dir, radius);
            posList.add(offsettedPos);
            if (!interCardinal) continue;
            class_2338 interCardinalPos = offsettedPos.method_10081(dir.method_10170().method_10163());
            posList.add(interCardinalPos);
        }
        if (includeReferencePoint) {
            posList.add(referencePoint);
        }
        return posList;
    }

    public static List<class_2338> findValidLocationInColumn(class_3218 level, class_2338 position, int minHeight, int maxBuildHeight) {
        ArrayList<class_2338> solutionsInRow = new ArrayList<class_2338>();
        List<class_2338> blockColumn = Teleporter.getBlockPosColumn(position, minHeight, maxBuildHeight);
        List<class_2338> filteredForAir = blockColumn.stream().filter(x -> Teleporter.isLegalLandingBlock(level, x)).toList();
        List<class_2338> filteredForNonAir = blockColumn.stream().filter(x -> !Teleporter.isLegalLandingBlock(level, x)).toList();
        for (class_2338 airPos : filteredForAir) {
            if (level.method_27983() == class_1937.field_25180 && airPos.method_10264() > 125) continue;
            class_2338 below = airPos.method_10074();
            class_2338 above = airPos.method_10084();
            if (!filteredForNonAir.contains(below) || !filteredForAir.contains(above) || !Teleporter.canPlaceTardis(level, airPos) || !Teleporter.isExitPositionSafe(level, airPos)) continue;
            solutionsInRow.add(airPos);
        }
        return solutionsInRow;
    }

    public static boolean isExitPositionSafe(class_3218 level, class_2338 pos) {
        return Teleporter.isLegalLandingBlock(level, pos.method_10084()) && Teleporter.isLegalLandingBlock(level, pos) && !Teleporter.isLegalLandingBlock(level, pos.method_10074());
    }

    private static boolean canPlaceTardis(class_3218 targetLevel, class_2338 pos) {
        return targetLevel.method_27983() == class_1937.field_25180 && pos.method_10264() <= 125;
    }

    public static boolean isLegalLandingBlock(class_3218 level, class_2338 pos) {
        class_2680 state = level.method_8320(pos);
        return state.method_26215() || state.method_45474() && state.method_26227().method_15769() && !state.method_26234((class_1922)level, pos);
    }

    private static class_2338 findClosestValidPositionFromTarget(List<class_2338> validPositions, class_2338 targetLocation) {
        int distance = Integer.MAX_VALUE;
        class_2338 intendedLocation = targetLocation;
        class_2338 closestSolution = class_2338.field_10980;
        for (class_2338 potentialLocation : validPositions) {
            int distanceBetween = Math.abs(potentialLocation.method_19455((class_2382)intendedLocation));
            if (distanceBetween >= distance) continue;
            distance = distanceBetween;
            closestSolution = potentialLocation;
        }
        return closestSolution;
    }

    private static List<class_2338> getBlockPosColumn(class_2338 referencePoint, int min, int max) {
        ArrayList<class_2338> positions = new ArrayList<class_2338>();
        for (int i = min; i <= max; ++i) {
            positions.add(new class_2338(referencePoint.method_10263(), i, referencePoint.method_10260()));
        }
        return positions;
    }

    private static boolean canTeleportTo(class_2338 pPos, class_1937 level, class_1297 entity) {
        class_7 blockpathtypes = class_14.method_23476((class_1922)level, (class_2338.class_2339)pPos.method_25503());
        if (blockpathtypes != class_7.field_12) {
            return false;
        }
        class_2338 blockpos = pPos.method_10059((class_2382)entity.method_24515());
        return level.method_8587(entity, entity.method_5829().method_996(blockpos));
    }

    public static boolean performTeleport(class_1297 pEntity, class_3218 pLevel, int pX, int pY, int pZ, float pYaw, float pPitch, boolean playSound) {
        WeepingAngels.LOGGER.debug("Teleported {} to {} {} {}", new Object[]{pEntity.method_5476().getString(), pX, pY, pZ});
        class_2338 blockpos = new class_2338(pX, pY, pZ);
        if (!Teleporter.canTeleportTo(blockpos, (class_1937)pLevel, pEntity)) {
            return false;
        }
        if (!class_1937.method_25953((class_2338)blockpos)) {
            return false;
        }
        float f = class_3532.method_15393((float)pYaw);
        float f1 = class_3532.method_15393((float)pPitch);
        if (pEntity instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)pEntity;
            if (playSound) {
                serverPlayer.field_13987.method_14364((class_2596)new class_2767(class_6880.method_40223((Object)WASounds.TELEPORT.get()), class_3419.field_15250, (double)pX, (double)pY, (double)pZ, 0.25f, 1.0f, serverPlayer.method_37908().field_9229.method_43055()));
            }
            class_1923 chunkpos = new class_1923(new class_2338(pX, pY, pZ));
            pLevel.method_14178().method_17297(class_3230.field_19347, chunkpos, 1, (Object)pEntity.method_5628());
            pEntity.method_5848();
            if (serverPlayer.method_6113()) {
                serverPlayer.method_7358(true, true);
            }
            if (pLevel == pEntity.method_37908()) {
                serverPlayer.field_13987.method_14363((double)pX, (double)pY, (double)pZ, f, f1);
            } else {
                serverPlayer.method_14251(pLevel, (double)pX, (double)pY, (double)pZ, f, f1);
            }
            pEntity.method_5847(f);
        } else {
            float f2 = class_3532.method_15363((float)f1, (float)-90.0f, (float)90.0f);
            if (pLevel == pEntity.method_37908()) {
                pEntity.method_5808((double)pX, (double)pY, (double)pZ, f, f2);
                pEntity.method_5847(f);
            } else {
                pEntity.method_18375();
                class_1297 entity = pEntity;
                pEntity = pEntity.method_5864().method_5883((class_1937)pLevel);
                if (pEntity == null) {
                    return false;
                }
                pEntity.method_5878(entity);
                pEntity.method_5808((double)pX, (double)pY, (double)pZ, f, f2);
                pEntity.method_5847(f);
                entity.method_31745(class_1297.class_5529.field_27002);
                pLevel.method_18769(pEntity);
            }
        }
        if (!(pEntity instanceof class_1309) || !((class_1309)pEntity).method_6128()) {
            pEntity.method_18799(pEntity.method_18798().method_18805(1.0, 0.0, 1.0));
            pEntity.method_24830(true);
        }
        if (pEntity instanceof class_1314) {
            ((class_1314)pEntity).method_5942().method_6340();
        }
        return true;
    }
}

