/*
 * Decompiled with CFR 0.152.
 */
package dev.jeryn.angels.util;

import dev.jeryn.angels.WAConfiguration;
import dev.jeryn.angels.common.WASounds;
import dev.jeryn.angels.common.entity.angel.WeepingAngel;
import dev.jeryn.angels.util.WADamageSources;
import dev.jeryn.angels.util.WATags;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_8111;

public class HurtHelper {
    public static boolean validatePickaxe(class_1657 player, WeepingAngel weepingAngel, Predicate<class_1799> predicate) {
        class_1799 heldItem = player.method_6118(class_1304.field_6173);
        class_1792 class_17922 = weepingAngel.getVariant().getDrops().method_7909();
        if (class_17922 instanceof class_1747) {
            class_1747 blockItem = (class_1747)class_17922;
            return predicate.test(heldItem) && heldItem.method_7909().method_7856(blockItem.method_7711().method_9564());
        }
        return heldItem.method_31573(WATags.ATTACK_OVERRIDES);
    }

    public static boolean handleAngelHurt(WeepingAngel weepingAngel, class_1282 pSource, float pAmount) {
        if (pSource.method_49708(class_8111.field_42347)) {
            return true;
        }
        HurtType hurtType = (HurtType)((Object)WAConfiguration.CONFIG.hurtType.get());
        switch (hurtType) {
            case NONE: {
                return false;
            }
            case PICKAXE: {
                return HurtHelper.hasPickAxe(weepingAngel, pSource, itemStack -> true);
            }
            case GENERATOR: {
                return pSource.method_49708(WADamageSources.GENERATOR);
            }
            case PICKAXE_AND_GENERATOR: {
                return pSource.method_49708(WADamageSources.GENERATOR) || HurtHelper.hasPickAxe(weepingAngel, pSource, itemStack -> true);
            }
            case ANYTHING: {
                return true;
            }
        }
        return false;
    }

    private static boolean hasPickAxe(WeepingAngel weepingAngel, class_1282 pSource, Predicate<class_1799> predicate) {
        class_1297 class_12972 = pSource.method_5529();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            boolean hasPickAxe = HurtHelper.validatePickaxe(player, weepingAngel, predicate);
            if (!hasPickAxe) {
                class_1937 class_19372;
                if (weepingAngel.method_37908().field_9229.method_43048(100) <= 10) {
                    weepingAngel.method_43077(WASounds.ANGEL_MOCKING.get());
                }
                if ((class_19372 = player.method_37908()) instanceof class_3218) {
                    class_3218 serverLevel = (class_3218)class_19372;
                    player.method_5643(WADamageSources.getSource(serverLevel, WADamageSources.PUNCH_STONE), (float)weepingAngel.method_37908().field_9229.method_43048(5));
                }
                return false;
            }
            class_1799 stack = player.method_6118(class_1304.field_6173);
            stack.method_7956(weepingAngel.method_37908().field_9229.method_43048(4), (class_1309)weepingAngel, livingEntity -> {
                weepingAngel.method_43077(WASounds.ANGEL_MOCKING.get());
                livingEntity.method_20236(class_1268.field_5808);
            });
            return true;
        }
        return false;
    }

    public static enum HurtType {
        PICKAXE,
        PICKAXE_AND_GENERATOR,
        NONE,
        GENERATOR,
        ANYTHING;

    }
}

