/*
 * Decompiled with CFR 0.152.
 */
package dev.jeryn.angels.network;

import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.jeryn.angels.network.Message;
import dev.jeryn.angels.network.MessageC2S;
import dev.jeryn.angels.network.MessageS2C;
import dev.jeryn.angels.network.MessageType;
import dev.jeryn.angels.network.fabric.NetworkManagerImpl;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public abstract class NetworkManager {
    protected final class_2960 channelName;
    protected final Map<String, MessageType> toServer = new HashMap<String, MessageType>();
    protected final Map<String, MessageType> toClient = new HashMap<String, MessageType>();

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static NetworkManager create(class_2960 channelName) {
        return NetworkManagerImpl.create(channelName);
    }

    public NetworkManager(class_2960 channelName) {
        this.channelName = channelName;
    }

    public MessageType registerS2C(String id, MessageDecoder<MessageS2C> decoder) {
        MessageType msgType = new MessageType(id, this, decoder, false);
        this.toClient.put(id, msgType);
        return msgType;
    }

    public MessageType registerC2S(String id, MessageDecoder<MessageC2S> decoder) {
        MessageType msgType = new MessageType(id, this, decoder, true);
        this.toServer.put(id, msgType);
        return msgType;
    }

    public abstract void sendToServer(MessageC2S var1);

    public abstract void sendToPlayer(class_3222 var1, MessageS2C var2);

    public void sendToDimension(class_1937 level, MessageS2C message) {
        if (!level.field_9236) {
            for (class_1657 player : level.method_18456()) {
                this.sendToPlayer((class_3222)player, message);
            }
        }
    }

    @FunctionalInterface
    public static interface MessageDecoder<T extends Message> {
        public T decode(class_2540 var1);
    }
}

