/*
 * Decompiled with CFR 0.152.
 */
package dev.jeryn.angels.fabric;

import dev.jeryn.angels.client.DetectorOverlay;
import dev.jeryn.angels.client.models.ModelRegistration;
import dev.jeryn.angels.client.render.blockentity.CoffinRenderer;
import dev.jeryn.angels.client.render.blockentity.GeneratorRenderer;
import dev.jeryn.angels.client.render.blockentity.SnowAngelRenderer;
import dev.jeryn.angels.client.render.blockentity.StatueRenderer;
import dev.jeryn.angels.client.render.entity.ThrowableGeneratorRenderer;
import dev.jeryn.angels.client.render.entity.WeepingAngelRenderer;
import dev.jeryn.angels.common.WAEntities;
import dev.jeryn.angels.common.blockentity.WABlockEntities;
import dev.jeryn.angels.common.blocks.WABlocks;
import dev.jeryn.angels.common.items.WAItems;
import dev.jeryn.angels.donators.DonationChecker;
import dev.jeryn.angels.util.WAHelper;
import java.util.List;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.rendering.v1.BlockEntityRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_4208;
import net.minecraft.class_5272;
import net.minecraft.class_5321;
import net.minecraft.class_6395;
import net.minecraft.class_7391;

public class WeepingAngelsClient
implements ClientModInitializer {
    public void onInitializeClient() {
        this.entityRenders();
        this.beRenders();
        this.itemPredicates();
        ModelRegistration.init();
        this.overlay();
        DonationChecker.checkForUpdate(true);
    }

    private void overlay() {
        HudRenderCallback.EVENT.register((matrixStack, tickDelta) -> DetectorOverlay.renderOverlay(matrixStack));
    }

    private void beRenders() {
        BlockEntityRendererRegistry.register(WABlockEntities.COFFIN.get(), CoffinRenderer::new);
        BlockEntityRendererRegistry.register(WABlockEntities.STATUE.get(), StatueRenderer::new);
        BlockEntityRendererRegistry.register(WABlockEntities.GENERATOR.get(), GeneratorRenderer::new);
        BlockEntityRendererRegistry.register(WABlockEntities.SNOW_ANGEL.get(), SnowAngelRenderer::new);
        BlockRenderLayerMap.INSTANCE.putBlock(WABlocks.COFFIN.get(), class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(WABlocks.STATUE.get(), class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(WABlocks.PLINTH.get(), class_1921.method_23581());
    }

    private void itemPredicates() {
        class_5272.method_27879((class_1792)WAItems.TIMEY_WIMEY_DETECTOR.get(), (class_2960)new class_2960("weeping_angels", "time"), (class_6395)new class_7391((clientLevel, itemStack, entity) -> {
            List<class_1297> anomaliesAround = WAHelper.getAnomaliesAroundEntity(entity, 64);
            if (anomaliesAround.isEmpty()) {
                return null;
            }
            return class_4208.method_19443((class_5321)entity.method_37908().method_27983(), (class_2338)anomaliesAround.get(0).method_24515());
        }));
    }

    private void entityRenders() {
        EntityRendererRegistry.register(WAEntities.WEEPING_ANGEL.get(), WeepingAngelRenderer::new);
        EntityRendererRegistry.register(WAEntities.GENERATOR.get(), ThrowableGeneratorRenderer::new);
    }
}

