/*
 * Decompiled with CFR 0.152.
 */
package dev.jeryn.angels.common.entity.angel.ai;

import dev.jeryn.angels.WeepingAngels;
import dev.jeryn.angels.common.entity.angel.WeepingAngel;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Map;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2960;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_6908;

public class AngelVariant {
    public static final Map<class_2960, AngelVariant> ORE_VARIANTS = (Map)class_156.method_654((Object)new Object2ObjectOpenHashMap(), objectOpenHashMap -> objectOpenHashMap.defaultReturnValue((Object)IRON));
    public static AngelVariant STONE;
    public static AngelVariant BASALT;
    public static AngelVariant DIRT;
    public static AngelVariant COPPER;
    public static AngelVariant MOSSY;
    public static AngelVariant RUSTED;
    public static AngelVariant RUSTED_NO_ARM;
    public static AngelVariant RUSTED_NO_WING;
    public static AngelVariant RUSTED_NO_HEAD;
    public static AngelVariant QUARTZ;
    public static AngelVariant LAPIS_LAZULI;
    public static AngelVariant IRON;
    public static AngelVariant GOLD;
    public static AngelVariant EMERALD;
    public static AngelVariant DIAMOND;
    public static final Map<class_2960, AngelVariant> VARIANTS;
    public static AngelVariant GAS_STONE;
    public static AngelVariant GAS_RUSTED;
    public static AngelVariant A_DIZZLE;
    public static AngelVariant DOCTOR;
    private final class_1799 drops;
    private final class_2960 regName;

    public static void init() {
        STONE = AngelVariant.registerVariant(new class_2960("weeping_angels", "normal"), new class_1799((class_1935)class_2246.field_10340), false);
        DOCTOR = AngelVariant.registerVariant(new class_2960("weeping_angels", "doctor"), new class_1799((class_1935)class_2246.field_10340), false);
        BASALT = AngelVariant.registerVariant(new class_2960("weeping_angels", "basalt"), new class_1799((class_1935)class_2246.field_22091), false);
        COPPER = AngelVariant.registerVariant(new class_2960("weeping_angels", "copper"), new class_1799((class_1935)class_2246.field_27120), true);
        DIRT = AngelVariant.registerVariant(new class_2960("weeping_angels", "dirt"), new class_1799((class_1935)class_2246.field_10566), false);
        MOSSY = AngelVariant.registerVariant(new class_2960("weeping_angels", "mossy"), new class_1799((class_1935)class_2246.field_9989), false);
        RUSTED = AngelVariant.registerVariant(new class_2960("weeping_angels", "rusted"), new class_1799((class_1935)class_2246.field_9989), false);
        RUSTED_NO_ARM = AngelVariant.registerVariant(new class_2960("weeping_angels", "rusted_no_arm"), new class_1799((class_1935)class_2246.field_10474), false);
        RUSTED_NO_WING = AngelVariant.registerVariant(new class_2960("weeping_angels", "rusted_no_wing"), new class_1799((class_1935)class_2246.field_10474), false);
        RUSTED_NO_HEAD = AngelVariant.registerVariant(new class_2960("weeping_angels", "rusted_no_head"), new class_1799((class_1935)class_2246.field_10474), false);
        QUARTZ = AngelVariant.registerVariant(new class_2960("weeping_angels", "quartz"), new class_1799((class_1935)class_2246.field_10437), false);
        LAPIS_LAZULI = AngelVariant.registerVariant(new class_2960("weeping_angels", "lapis_lazuli"), new class_1799((class_1935)class_2246.field_10090), true);
        IRON = AngelVariant.registerVariant(new class_2960("weeping_angels", "iron"), new class_1799((class_1935)class_2246.field_10212), true);
        GOLD = AngelVariant.registerVariant(new class_2960("weeping_angels", "gold"), new class_1799((class_1935)class_2246.field_10571), true);
        EMERALD = AngelVariant.registerVariant(new class_2960("weeping_angels", "emerald"), new class_1799((class_1935)class_2246.field_10013), true);
        DIAMOND = AngelVariant.registerVariant(new class_2960("weeping_angels", "diamond"), new class_1799((class_1935)class_2246.field_10442), true);
        GAS_RUSTED = AngelVariant.registerVariant(new class_2960("weeping_angels", "gas_rusted"), new class_1799((class_1935)class_2246.field_10340), false);
        GAS_STONE = AngelVariant.registerVariant(new class_2960("weeping_angels", "gas_stone"), new class_1799((class_1935)class_2246.field_10474), false);
        A_DIZZLE = AngelVariant.registerVariant(new class_2960("weeping_angels", "a_dizzle"), new class_1799((class_1935)class_2246.field_10474), false);
    }

    public AngelVariant(class_2960 resourceLocation, class_1799 drops) {
        this.drops = drops;
        this.regName = resourceLocation;
    }

    public class_2960 location() {
        return this.regName;
    }

    public class_1799 getDrops() {
        return this.drops;
    }

    public static AngelVariant getVariantForPos(WeepingAngel weepingAngel) {
        class_1937 level = weepingAngel.method_37908();
        class_5819 randomSource = level.field_9229;
        boolean isOrePosition = weepingAngel.method_24515().method_10264() < 50 && !level.method_8311(weepingAngel.method_24515());
        class_6880 currentBiome = level.method_23753(weepingAngel.method_24515());
        boolean isNether = currentBiome.method_40220(class_6908.field_36518);
        boolean isJungle = currentBiome.method_40220(class_6908.field_36516);
        if (isJungle) {
            return MOSSY;
        }
        if (isNether) {
            return randomSource.method_43056() ? QUARTZ : BASALT;
        }
        if (isOrePosition && randomSource.method_43048(100) < 10) {
            return AngelVariant.getRandomVariant(ORE_VARIANTS, randomSource);
        }
        Collection<AngelVariant> variants = VARIANTS.values();
        variants.removeIf(angelTextureVariant -> angelTextureVariant == QUARTZ || angelTextureVariant == MOSSY || angelTextureVariant == BASALT || ORE_VARIANTS.containsKey(angelTextureVariant.regName));
        return variants.stream().skip((int)((double)variants.size() * Math.random())).findFirst().get();
    }

    public static AngelVariant getRandomVariant(Map<class_2960, AngelVariant> variantMap, class_5819 randomSource) {
        int index = randomSource.method_43048(variantMap.size());
        return variantMap.values().toArray(new AngelVariant[0])[index];
    }

    public static AngelVariant getVariant(class_2960 resourceLocation) {
        if (VARIANTS.containsKey(resourceLocation)) {
            return VARIANTS.get(resourceLocation);
        }
        return STONE;
    }

    public static AngelVariant registerVariant(class_2960 resourceLocation, class_1799 itemStack, boolean isOre) {
        WeepingAngels.LOGGER.info("Registered: {}", (Object)resourceLocation);
        return AngelVariant.registerVariant(resourceLocation, new AngelVariant(resourceLocation, itemStack), isOre);
    }

    public static AngelVariant registerVariant(class_2960 resourceLocation, AngelVariant angelVariant, boolean isOre) {
        if (isOre) {
            ORE_VARIANTS.put(resourceLocation, angelVariant);
        }
        if (VARIANTS.containsKey(resourceLocation)) {
            VARIANTS.replace(resourceLocation, angelVariant);
        }
        VARIANTS.put(resourceLocation, angelVariant);
        return angelVariant;
    }

    static {
        VARIANTS = (Map)class_156.method_654((Object)new Object2ObjectOpenHashMap(), objectOpenHashMap -> objectOpenHashMap.defaultReturnValue((Object)STONE));
    }
}

