/*
 * Decompiled with CFR 0.152.
 */
package dev.jeryn.angels.common.entity.angel;

import com.google.common.collect.ImmutableList;
import dev.jeryn.angels.WAConfiguration;
import dev.jeryn.angels.common.CatacombTracker;
import dev.jeryn.angels.common.WAEntities;
import dev.jeryn.angels.common.WASounds;
import dev.jeryn.angels.common.entity.angel.AbstractWeepingAngel;
import dev.jeryn.angels.common.entity.angel.BlockReactions;
import dev.jeryn.angels.common.entity.angel.ai.AngelEmotion;
import dev.jeryn.angels.common.entity.angel.ai.AngelVariant;
import dev.jeryn.angels.common.items.WAItems;
import dev.jeryn.angels.util.HurtHelper;
import dev.jeryn.angels.util.Teleporter;
import dev.jeryn.angels.util.WADamageSources;
import dev.jeryn.angels.util.WATags;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1352;
import net.minecraft.class_1366;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1408;
import net.minecraft.class_1410;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2767;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_4255;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_6868;
import net.minecraft.class_6880;
import net.minecraft.class_7094;
import net.minecraft.class_7260;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WeepingAngel
extends AbstractWeepingAngel {
    public class_7094 POSE_ANIMATION_STATE = new class_7094();
    private int fakeAnimation = -1;

    public int getFakeAnimation() {
        return this.fakeAnimation;
    }

    public void setFakeAnimation(int fakeAnimation) {
        this.fakeAnimation = fakeAnimation;
    }

    public WeepingAngel(class_1937 worldIn) {
        super(worldIn, WAEntities.WEEPING_ANGEL.get());
        int id = 0;
        this.field_6201.method_6277(id++, (class_1352)new class_4255((class_1308)this, false));
        this.field_6201.method_6277(id++, (class_1352)new class_1366((class_1314)this, 0.5, true));
        this.field_6201.method_6277(id++, (class_1352)new class_6868((class_1308)this, this.method_37908()));
        this.field_6185.method_6277(id++, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
        this.field_6185.method_6277(id++, (class_1352)new class_1399((class_1314)this, new Class[0]).method_6318(new Class[]{WeepingAngel.class}));
    }

    @Nullable
    public class_1315 method_5943(class_5425 level, class_1266 difficulty, class_3730 reason, @Nullable class_1315 spawnData, @Nullable class_2487 dataTag) {
        this.setVariant(AngelVariant.getVariantForPos(this));
        return super.method_5943(level, difficulty, reason, spawnData, dataTag);
    }

    @Nullable
    public class_1799 method_31480() {
        return new class_1799((class_1935)WAItems.ANGEL_SPAWNER.get());
    }

    public boolean method_6121(class_1297 pEntity) {
        class_3218 serverLevel;
        if (!(pEntity instanceof class_1657)) {
            return false;
        }
        class_1657 player = (class_1657)pEntity;
        float attackDamage = (float)this.method_26825(class_5134.field_23721);
        class_3218 class_32182 = serverLevel = pEntity.method_37908() instanceof class_3218 ? (class_3218)pEntity.method_37908() : null;
        if (serverLevel == null) {
            return false;
        }
        if (this.field_5974.method_43048(100) < (Integer)WAConfiguration.CONFIG.teleportChance.get()) {
            class_3218 chosenDimension = (Boolean)WAConfiguration.CONFIG.interdimensionalTeleporting.get() != false ? Teleporter.getRandomDimension(this.field_5974, serverLevel) : serverLevel;
            int teleportRange = (Integer)WAConfiguration.CONFIG.teleportRange.get();
            for (int i = 0; i < 10; ++i) {
                int xCoord = (int)(this.method_23317() + (double)this.field_5974.method_43048(teleportRange));
                int zCoord = (int)(this.method_23321() + (double)this.field_5974.method_43048(teleportRange));
                class_2338 finalY = Teleporter.findClosestValidPosition(chosenDimension, new class_2338(xCoord, this.field_5974.method_43048(161) - 40, zCoord));
                if (finalY == null) {
                    return false;
                }
                if (!Teleporter.performTeleport(pEntity, chosenDimension, xCoord, finalY.method_10264(), zCoord, pEntity.method_36454(), pEntity.method_36455(), true)) continue;
                return true;
            }
            return false;
        }
        this.stealItems(player);
        boolean didHurt = pEntity.method_5643(WADamageSources.getSource(serverLevel, WADamageSources.SNAPPED_NECK), attackDamage);
        this.method_5723((class_1309)this, pEntity);
        this.method_6114(pEntity);
        return didHurt;
    }

    public boolean method_5874(class_3218 serverLevel, class_1309 livingEntity) {
        boolean wasKilled = super.method_5874(serverLevel, livingEntity);
        if (wasKilled) {
            this.method_43077(WASounds.NECK_SNAP.get());
        }
        return wasKilled;
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        if (!state.method_51176()) {
            class_2680 blockState = class_2246.field_10340.method_9564();
            class_2498 soundType = blockState.method_26231();
            this.method_5783(soundType.method_10594(), soundType.method_10597() * 0.15f, soundType.method_10599());
        }
    }

    public void method_5697(class_1297 entity) {
        super.method_5697(entity);
        this.method_6121(entity);
    }

    protected void method_6087(class_1297 entity) {
        super.method_6087(entity);
        this.method_6121(entity);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        class_1937 level = this.method_37908();
        if (!level.method_8608() && CatacombTracker.isInCatacomb((class_1309)this)) {
            class_7260.method_42204((class_3218)((class_3218)level), (class_243)this.method_19538(), (class_1297)this, (int)20);
        }
        if (!this.POSE_ANIMATION_STATE.method_41327()) {
            this.POSE_ANIMATION_STATE.method_41322(this.field_6012 - this.field_5974.method_43048(10000));
        }
        if (this.isSeen() && (!this.method_24828() || level.method_22345(this.method_5829())) && !this.isHooked()) {
            this.setSeenTime(0);
            this.method_5977(false);
        }
        if (this.field_6012 % 400 == 0) {
            if (this.isHooked()) {
                this.setHooked(false);
            }
            if (this.isSeen()) {
                this.investigateBlocks();
            }
        }
    }

    public void stealItems(class_1657 player) {
        if (!((Boolean)WAConfiguration.CONFIG.angelTheft.get()).booleanValue()) {
            return;
        }
        if (!this.method_6047().method_7960()) {
            return;
        }
        class_1661 playerInv = player.method_31548();
        for (int i = 0; i < playerInv.field_7547.size(); ++i) {
            class_1799 item = (class_1799)playerInv.field_7547.get(i);
            if (!item.method_31573(WATags.STEALABLE_ITEMS) || !this.method_5998(class_1268.field_5808).method_7960()) continue;
            this.method_6122(class_1268.field_5808, item.method_7972());
            this.method_25939(class_1304.field_6173);
            playerInv.method_5447(i, class_1799.field_8037);
            return;
        }
    }

    @NotNull
    protected class_1408 method_5965(@NotNull class_1937 worldIn) {
        class_1410 navigator = new class_1410((class_1308)this, worldIn);
        navigator.method_6354(false);
        navigator.method_6363(true);
        navigator.method_6361(false);
        navigator.method_6344(1.0);
        return navigator;
    }

    public void method_5768() {
        this.method_5650(class_1297.class_5529.field_26998);
    }

    public boolean method_6101() {
        return this.field_5976;
    }

    @Override
    public void invokeSeen(class_1657 player) {
        super.invokeSeen(player);
        if (this.getSeenTime() == 1 && System.currentTimeMillis() - this.timeSincePlayedSound > 5000L) {
            this.setEmotion(AngelEmotion.randomEmotion(this.field_5974));
            this.method_43077(class_3417.field_14574);
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                if (player.method_5739((class_1297)this) < 15.0f) {
                    this.setTimeSincePlayedSound(System.currentTimeMillis());
                    serverPlayer.field_13987.method_14364((class_2596)new class_2767(class_6880.method_40223((Object)this.getSeenSound()), class_3419.field_15245, player.method_23317(), player.method_23318(), player.method_23321(), 0.25f, 1.0f, this.field_5974.method_43055()));
                }
            }
        }
    }

    protected class_3414 method_6011(class_1282 pDamageSource) {
        return class_3417.field_14658;
    }

    protected class_3414 method_6002() {
        return WASounds.CRUMBLING.get();
    }

    public boolean method_5643(class_1282 pSource, float pAmount) {
        class_1937 level = this.method_37908();
        if (!level.method_8608()) {
            boolean isHurt = HurtHelper.handleAngelHurt(this, pSource, pAmount);
            class_3218 serverLevel = (class_3218)level;
            if (isHurt) {
                class_1792 class_17922 = this.getVariant().getDrops().method_7909();
                if (class_17922 instanceof class_1747) {
                    class_1747 blockItem = (class_1747)class_17922;
                    class_2680 defaultState = blockItem.method_7711().method_9564();
                    this.method_43077(defaultState.method_26231().method_10596());
                }
                serverLevel.method_14199((class_2394)new class_2388(class_2398.field_11217, class_2246.field_10340.method_9564()), this.method_23317(), this.method_23323(0.5), this.method_23321(), 5, 0.1, 0.0, 0.1, 0.2);
                return super.method_5643(pSource, pAmount);
            }
        }
        return false;
    }

    protected void method_6108() {
        class_1937 level = this.method_37908();
        ++this.field_6213;
        if (this.field_6213 == 20 && !level.method_8608()) {
            if (this.method_27071()) {
                class_1542 itemEntity = new class_1542(class_1299.field_6052, level);
                itemEntity.method_6979(this.getVariant().getDrops());
                itemEntity.method_5814(this.method_23317(), this.method_23318(), this.method_23321());
                level.method_8649((class_1297)itemEntity);
            }
            this.method_5650(class_1297.class_5529.field_26998);
        }
    }

    public void investigateBlocks() {
        class_1937 level = this.method_37908();
        if (level.method_8608() || !level.method_8450().method_8355(class_1928.field_19388) || !((Boolean)WAConfiguration.CONFIG.blockBreaking.get()).booleanValue()) {
            return;
        }
        Iterator iterator = class_2338.method_25998((class_2338)this.method_24515(), (int)25, (int)3, (int)25).iterator();
        while (iterator.hasNext()) {
            class_2338 pos = (class_2338)iterator.next();
            class_2680 blockState = level.method_8320(pos);
            BlockReactions.BlockReaction blockBehaviour = BlockReactions.BLOCK_BEHAVIOUR.get(blockState.method_26204());
            boolean completed = blockBehaviour.interact(this, blockState, level, pos);
            if (!completed) continue;
            class_7260.method_42204((class_3218)((class_3218)level), (class_243)class_243.method_24955((class_2382)this.method_24515()), (class_1297)this, (int)64);
            return;
        }
    }

    public Crackiness getCrackiness() {
        return Crackiness.byFraction(this.method_6032() / this.method_6063());
    }

    public static enum Crackiness {
        NONE(1.0f),
        LOW(0.75f),
        MEDIUM(0.5f),
        HIGH(0.25f);

        private static final List<Crackiness> BY_DAMAGE;
        private final float fraction;

        private Crackiness(float pFraction) {
            this.fraction = pFraction;
        }

        public static Crackiness byFraction(float pFraction) {
            for (Crackiness crackiness : BY_DAMAGE) {
                if (!(pFraction < crackiness.fraction)) continue;
                return crackiness;
            }
            return NONE;
        }

        static {
            BY_DAMAGE = (List)Stream.of(Crackiness.values()).sorted(Comparator.comparingDouble(crackiness -> crackiness.fraction)).collect(ImmutableList.toImmutableList());
        }
    }
}

