/*
 * Decompiled with CFR 0.152.
 */
package dev.jeryn.angels.common.entity.angel;

import dev.jeryn.angels.WAConfiguration;
import dev.jeryn.angels.common.entity.angel.ai.AngelEmotion;
import dev.jeryn.angels.common.entity.angel.ai.AngelVariant;
import dev.jeryn.angels.common.entity.angel.ai.BodyRotationAngel;
import dev.jeryn.angels.util.ViewUtil;
import dev.jeryn.angels.util.WAHelper;
import java.util.List;
import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1330;
import net.minecraft.class_1569;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractWeepingAngel
extends class_1588
implements class_1569 {
    private static final class_2940<Integer> TIME_VIEWED = class_2945.method_12791(AbstractWeepingAngel.class, (class_2941)class_2943.field_13327);
    private static final class_2940<String> EMOTION = class_2945.method_12791(AbstractWeepingAngel.class, (class_2941)class_2943.field_13326);
    private static final class_2940<Boolean> IS_HOOKED = class_2945.method_12791(AbstractWeepingAngel.class, (class_2941)class_2943.field_13323);
    private static final class_2940<String> VARIANT = class_2945.method_12791(AbstractWeepingAngel.class, (class_2941)class_2943.field_13326);
    private static final class_2940<Boolean> SHOULD_DROP_LOOT = class_2945.method_12791(AbstractWeepingAngel.class, (class_2941)class_2943.field_13323);
    public long timeSincePlayedSound = 0L;

    public AbstractWeepingAngel(class_1937 worldIn, class_1299<? extends class_1588> entityType) {
        super(entityType, worldIn);
    }

    public static class_5132.class_5133 createAttributes() {
        return AbstractWeepingAngel.method_26918().method_26868(class_5134.field_23721, 8.0).method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_23718, 1.0).method_26868(class_5134.field_23719, 0.8).method_26868(class_5134.field_23724, 2.0);
    }

    public void method_5773() {
        super.method_5773();
        if (this.getSeenTime() == 0) {
            this.method_5977(false);
        }
    }

    public void method_6007() {
        if (!this.method_6047().method_7960()) {
            this.method_5971();
        }
        super.method_6007();
        if (!this.method_37908().field_9236) {
            List players = this.method_37908().method_18467(class_1657.class, this.method_5829().method_1014((double)((Integer)WAConfiguration.CONFIG.stalkRange.get()).intValue()));
            players.removeIf(player -> player.method_7325() || player.method_5767() || player.method_6113() || player.method_37908() != this.method_37908());
            if (players.isEmpty()) {
                this.setSeenTime(0);
                this.method_6125(0.5f);
                return;
            }
            class_1657 targetPlayer = null;
            for (class_1657 player2 : players) {
                if (ViewUtil.isInSight((class_1309)player2, this)) {
                    this.setSeenTime(this.getSeenTime() + 1);
                    this.invokeSeen(player2);
                    return;
                }
                if (targetPlayer != null) continue;
                targetPlayer = player2;
                this.setSeenTime(0);
                this.method_6125(0.5f);
            }
            if (this.isSeen()) {
                return;
            }
            this.snapLookToPlayer(targetPlayer);
            this.moveTowards((class_1309)targetPlayer);
        }
    }

    public void method_5844(class_2680 state, @NotNull class_243 motionMultiplierIn) {
        if (!state.method_27852(class_2246.field_10343)) {
            super.method_5844(state, motionMultiplierIn);
        }
    }

    private void snapLookToPlayer(class_1657 targetPlayer) {
        class_243 vecPos = this.method_19538();
        class_243 vecPlayerPos = targetPlayer.method_19538();
        float angle = (float)Math.toDegrees((float)Math.atan2(vecPos.field_1350 - vecPlayerPos.field_1350, vecPos.field_1352 - vecPlayerPos.field_1352));
        this.field_6283 = angle > 180.0f ? angle : angle + 90.0f;
        this.field_6241 = this.field_6283;
    }

    public void moveTowards(class_1309 targetPlayer) {
        this.method_5942().method_6335((class_1297)targetPlayer, (double)this.method_6029());
    }

    protected void method_5693() {
        super.method_5693();
        this.method_5841().method_12784(TIME_VIEWED, (Object)0);
        this.method_5841().method_12784(EMOTION, (Object)AngelEmotion.IDLE.getId());
        this.method_5841().method_12784(IS_HOOKED, (Object)false);
        this.method_5841().method_12784(VARIANT, (Object)AngelVariant.BASALT.location().toString());
        this.method_5841().method_12784(SHOULD_DROP_LOOT, (Object)true);
    }

    protected boolean method_27071() {
        return (Boolean)this.method_5841().method_12789(SHOULD_DROP_LOOT);
    }

    public AngelVariant getVariant() {
        return AngelVariant.getVariant(new class_2960((String)this.method_5841().method_12789(VARIANT)));
    }

    public void setVariant(AngelVariant angelVariant) {
        this.method_5841().method_12778(VARIANT, (Object)angelVariant.location().toString());
    }

    public AngelEmotion getEmotion() {
        String emotion = (String)this.method_5841().method_12789(EMOTION);
        for (AngelEmotion angelEmotion : AngelEmotion.values()) {
            if (!emotion.equalsIgnoreCase(angelEmotion.getId())) continue;
            return angelEmotion;
        }
        return AngelEmotion.IDLE;
    }

    public void setEmotion(AngelEmotion angelEmotion) {
        this.method_5841().method_12778(EMOTION, (Object)angelEmotion.getId());
    }

    public boolean isHooked() {
        return (Boolean)this.method_5841().method_12789(IS_HOOKED);
    }

    public void setHooked(boolean hooked) {
        this.method_5841().method_12778(IS_HOOKED, (Object)hooked);
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        if (compound.method_10545("timeSeen")) {
            this.setSeenTime(compound.method_10550("timeSeen"));
        }
        if (compound.method_10545("emotion")) {
            this.setEmotion(AngelEmotion.find(compound.method_10558("emotion").toUpperCase()));
        }
        if (compound.method_10545("isHooked")) {
            this.setEmotion(AngelEmotion.find(compound.method_10558("emotion").toUpperCase()));
        }
        if (compound.method_10545("dropsLoot")) {
            this.setDrops(compound.method_10577("dropsLoot"));
        }
        if (compound.method_10545("angelVariant")) {
            this.setVariant(AngelVariant.getVariant(new class_2960(compound.method_10558("angelVariant"))));
        }
    }

    public void setDrops(boolean drops) {
        this.method_5841().method_12778(SHOULD_DROP_LOOT, (Object)drops);
    }

    public void method_5652(@NotNull class_2487 compound) {
        super.method_5652(compound);
        compound.method_10556("isSeen", this.isSeen());
        compound.method_10569("timeSeen", this.getSeenTime());
        compound.method_10582("emotion", this.getEmotion().getId());
        compound.method_10556("dropsLoot", this.method_27071());
        compound.method_10582("angelVariant", this.getVariant().location().toString());
    }

    public class_2596<class_2602> method_18002() {
        return WAHelper.spawnPacket((class_1297)this);
    }

    public class_3414 getSeenSound() {
        AngelVariant angelVariant = this.getVariant();
        class_1799 itemStack = angelVariant.getDrops();
        class_1792 class_17922 = itemStack.method_7909();
        if (class_17922 instanceof class_1747) {
            class_1747 blockItem = (class_1747)class_17922;
            class_2248 block = blockItem.method_7711();
            return block.method_9564().method_26231().method_10595();
        }
        return class_3417.field_14574;
    }

    public boolean method_6094() {
        return true;
    }

    public boolean method_5862() {
        return false;
    }

    public long getTimeSincePlayedSound() {
        return this.timeSincePlayedSound;
    }

    public void setTimeSincePlayedSound(long timeSincePlayedSound) {
        this.timeSincePlayedSound = timeSincePlayedSound;
    }

    public boolean isSeen() {
        return this.getSeenTime() > 0;
    }

    public int getSeenTime() {
        return (Integer)this.method_5841().method_12789(TIME_VIEWED);
    }

    public void setSeenTime(int time) {
        this.method_5841().method_12778(TIME_VIEWED, (Object)time);
    }

    public void method_6005(double strength, double x, double z) {
    }

    @NotNull
    protected class_1330 method_5963() {
        return new BodyRotationAngel((class_1308)this);
    }

    public void invokeSeen(class_1657 player) {
        this.method_5942().method_6334((class_11)null, 0.0);
        this.method_5977(true);
    }

    protected boolean method_6062() {
        return this.getSeenTime() > 0;
    }
}

