/*
 * Decompiled with CFR 0.152.
 */
package dev.jeryn.angels;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import dev.jeryn.angels.util.Platform;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1311;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_6908;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;

public class WAEntitySpawns {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File("config/weeping_angels_spawns.json");
    private static Map<class_2960, BiomeSpawnConfig> biomeSpawnConfigs = new HashMap<class_2960, BiomeSpawnConfig>();

    public static void init(MinecraftServer minecraftServer) {
        WAEntitySpawns.loadConfig();
    }

    public static boolean canSpawnInThisBiome(class_1959 biome) {
        class_2378 biomeRegistry = (class_2378)Platform.getServer().method_30611().method_33310(class_7924.field_41236).get();
        if (!biomeSpawnConfigs.containsKey(biomeRegistry.method_10221((Object)biome))) {
            return false;
        }
        return WAEntitySpawns.biomeSpawnConfigs.get((Object)biomeRegistry.method_10221((Object)biome)).canSpawnHere;
    }

    public static class_1311 getSpawnType(class_1959 biome) {
        class_2378 biomeRegistry = (class_2378)Platform.getServer().method_30611().method_33310(class_7924.field_41236).get();
        if (!biomeSpawnConfigs.containsKey(biomeRegistry.method_10221((Object)biome))) {
            return class_1311.field_6302;
        }
        return WAEntitySpawns.biomeSpawnConfigs.get((Object)biomeRegistry.method_10221((Object)biome)).mobCategory;
    }

    public static Integer getSpawnMin(class_1959 biome) {
        class_2378 biomeRegistry = (class_2378)Platform.getServer().method_30611().method_33310(class_7924.field_41236).get();
        if (!biomeSpawnConfigs.containsKey(biomeRegistry.method_10221((Object)biome))) {
            return 0;
        }
        return WAEntitySpawns.biomeSpawnConfigs.get((Object)biomeRegistry.method_10221((Object)biome)).minCount;
    }

    public static Integer getSpawnMax(class_1959 biome) {
        class_2378 biomeRegistry = (class_2378)Platform.getServer().method_30611().method_33310(class_7924.field_41236).get();
        if (!biomeSpawnConfigs.containsKey(biomeRegistry.method_10221((Object)biome))) {
            return 0;
        }
        return WAEntitySpawns.biomeSpawnConfigs.get((Object)biomeRegistry.method_10221((Object)biome)).maxCount;
    }

    public static Integer getSpawnWeight(class_1959 biome) {
        class_2378 biomeRegistry = (class_2378)Platform.getServer().method_30611().method_33310(class_7924.field_41236).get();
        if (!biomeSpawnConfigs.containsKey(biomeRegistry.method_10221((Object)biome))) {
            return 0;
        }
        return WAEntitySpawns.biomeSpawnConfigs.get((Object)biomeRegistry.method_10221((Object)biome)).spawnWeight;
    }

    public static void loadConfig() {
        if (CONFIG_FILE.exists()) {
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                Type type = new TypeToken<Map<String, BiomeSpawnConfig>>(){}.getType();
                Map configMap = (Map)GSON.fromJson((Reader)reader, type);
                for (Map.Entry entry : configMap.entrySet()) {
                    biomeSpawnConfigs.put(new class_2960((String)entry.getKey()), (BiomeSpawnConfig)entry.getValue());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            WAEntitySpawns.generateDefaultConfig();
        }
    }

    public static void saveConfig() {
        HashMap<String, BiomeSpawnConfig> configMap = new HashMap<String, BiomeSpawnConfig>();
        for (Map.Entry<class_2960, BiomeSpawnConfig> entry : biomeSpawnConfigs.entrySet()) {
            configMap.put(entry.getKey().toString(), entry.getValue());
        }
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson(configMap, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void generateDefaultConfig() {
        class_2378 biomeRegistry = (class_2378)Platform.getServer().method_30611().method_33310(class_7924.field_41236).get();
        for (class_1959 biome : biomeRegistry) {
            boolean canSpawnHere;
            class_2960 biomeKey = biomeRegistry.method_10221((Object)biome);
            boolean isNetherBiome = WAEntitySpawns.isNetherBiome(biomeKey);
            boolean isTardis = WAEntitySpawns.isTardis(biomeKey);
            boolean isWater = WAEntitySpawns.isWater(biomeKey);
            int minCount = 1;
            int maxCount = 4;
            int spawnWeight = 8;
            boolean bl = canSpawnHere = !isTardis && !isWater;
            if (isNetherBiome) {
                minCount = 0;
                maxCount = 1;
                spawnWeight = 1;
            }
            BiomeSpawnConfig config = new BiomeSpawnConfig(class_1311.field_6302, minCount, maxCount, spawnWeight, canSpawnHere);
            biomeSpawnConfigs.put(biomeKey, config);
        }
        WAEntitySpawns.saveConfig();
    }

    private static boolean isNetherBiome(class_2960 biomeKey) {
        class_2378 biomeRegistry = (class_2378)Platform.getServer().method_30611().method_33310(class_7924.field_41236).get();
        return biomeRegistry.method_40266(class_6908.field_36518).map(tag -> tag.method_40241((class_6880)biomeRegistry.method_40290(class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)biomeKey)))).orElse(false);
    }

    private static boolean isWater(class_2960 biomeKey) {
        return biomeKey.method_12832().contains("ocean") || biomeKey.method_12832().contains("river");
    }

    private static boolean isTardis(class_2960 biomeKey) {
        return biomeKey.method_12832().contains("tardis");
    }

    public static class BiomeSpawnConfig {
        private final class_1311 mobCategory;
        public int minCount;
        public int maxCount;
        public int spawnWeight;
        public boolean canSpawnHere;

        public BiomeSpawnConfig(class_1311 mobCategory, int minCount, int maxCount, int spawnWeight, boolean canSpawnHere) {
            this.minCount = minCount;
            this.maxCount = maxCount;
            this.spawnWeight = spawnWeight;
            this.canSpawnHere = canSpawnHere;
            this.mobCategory = mobCategory;
        }
    }
}

