/*
 * Decompiled with CFR 0.152.
 */
package immersive_melodies.client;

import immersive_melodies.resources.ClientMelodyManager;
import immersive_melodies.resources.Melody;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_2960;

public class MelodyProgress {
    long lastTime;
    int time;
    String currentlyPlaying = "";
    String overwritten = null;
    long worldTime;
    final Map<Integer, Integer> lastIndex = new HashMap<Integer, Integer>();
    long lastNoteLongTime;
    int lastNoteTime;
    float lastVolume;
    float lastPitch;
    long lastLength;
    float current;
    float currentVolume;
    float currentPitch;
    float lastAnimationTime;
    float attackTime = 10.0f;
    float decayTime = 15.0f;

    public void tick(class_1799 stack) {
        long l = System.currentTimeMillis();
        long delta = l - this.lastTime;
        if (delta < 150L) {
            this.time += (int)delta;
        }
        this.lastTime = l;
        String identifier = stack.method_7948().method_10558("melody");
        long startTime = stack.method_7948().method_10537("start_time");
        if (!this.currentlyPlaying.equals(identifier)) {
            this.currentlyPlaying = identifier;
            this.overwritten = null;
            this.worldTime = startTime;
            this.time = 0;
            this.lastIndex.clear();
        }
        if (this.worldTime != startTime) {
            this.worldTime = startTime;
            this.overwritten = null;
            this.time = 0;
            this.lastIndex.clear();
        }
    }

    public long getTime() {
        return this.time;
    }

    public int getLastIndex(int track) {
        return this.lastIndex.getOrDefault(track, 0);
    }

    public void setLastIndex(int track, int index) {
        this.lastIndex.put(track, index);
    }

    public float getCurrent() {
        return this.current;
    }

    public float getCurrentVolume() {
        return this.currentVolume;
    }

    public float getCurrentPitch() {
        return this.currentPitch;
    }

    public String getCurrentlyPlaying() {
        return this.overwritten == null ? this.currentlyPlaying : this.overwritten;
    }

    public void overwrite(String by) {
        this.overwritten = by;
    }

    public void visualTick(float time) {
        boolean decayPhase = time - (float)this.lastNoteTime > this.attackTime;
        float delta = Math.max(0.0f, Math.min(1.0f, (time - this.lastAnimationTime) / (decayPhase ? this.decayTime : this.attackTime)));
        this.lastAnimationTime = time;
        if (delta > 0.0f) {
            this.current = this.current * (1.0f - delta) + (decayPhase ? 0.0f : 1.0f) * delta;
            this.currentPitch = this.currentPitch * (1.0f - delta) + this.lastPitch * delta;
            this.currentVolume = this.currentVolume * (1.0f - delta) + this.lastVolume * delta;
        }
    }

    public boolean isPlaying() {
        return this.delta() < 1000L;
    }

    public long delta() {
        return System.currentTimeMillis() - this.lastNoteLongTime;
    }

    public Melody getMelody() {
        return ClientMelodyManager.getMelody(new class_2960(this.getCurrentlyPlaying()));
    }
}

