/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.util;

import com.google.common.annotations.GwtCompatible;
import me.shedaniel.rei.impl.client.util.CyclingList;

@GwtCompatible
abstract class AbstractIndexedCyclingList<T>
implements CyclingList<T> {
    private int position = 0;

    AbstractIndexedCyclingList() {
    }

    protected abstract T get(int var1);

    protected abstract T empty();

    @Override
    public T peek() {
        int size = this.size();
        if (size == 0) {
            return this.empty();
        }
        return this.get(Math.floorMod(this.position, size));
    }

    @Override
    public T next() {
        int size = this.size();
        if (size == 0) {
            return this.empty();
        }
        int tmp = this.position;
        this.position = Math.floorMod(++tmp, size);
        return this.get(Math.floorMod(tmp, size));
    }

    @Override
    public int currentIndex() {
        return this.position;
    }

    @Override
    public int nextIndex() {
        return Math.floorMod(this.position + 1, this.size());
    }

    @Override
    public T previous() {
        int size = this.size();
        if (size == 0) {
            return this.empty();
        }
        this.position = Math.floorMod(--this.position, size);
        return this.get(this.position);
    }

    @Override
    public int previousIndex() {
        return Math.floorMod(this.position - 1, this.size());
    }

    @Override
    public void resetToStart() {
        this.position = 0;
    }

    public static abstract class Mutable<T>
    extends AbstractIndexedCyclingList<T>
    implements CyclingList.Mutable<T> {
    }
}

