/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.whisperwoods.imdlib.shadow.fiber2cloth.api;

import dev.itsmeow.whisperwoods.imdlib.shadow.fiber2cloth.api.ClothSetting;
import dev.itsmeow.whisperwoods.imdlib.shadow.fiber2cloth.api.DefaultTypes;
import dev.itsmeow.whisperwoods.imdlib.shadow.fiber2cloth.impl.ColorPickerFormat;
import dev.itsmeow.whisperwoods.imdlib.shadow.fiber2cloth.impl.Fiber2ClothImpl;
import dev.itsmeow.whisperwoods.imdlib.shadow.fiber2cloth.impl.GroupDisplayOption;
import io.github.fablabsmc.fablabs.api.fiber.v1.FiberId;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.ConfigTypes;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigAttribute;
import net.minecraft.class_2378;
import net.minecraft.class_2385;
import net.minecraft.class_2960;

public final class ClothAttributes {
    public static final FiberId DEFAULT_BACKGROUND = ClothAttributes.id("default_background");
    public static final FiberId TRANSPARENT_BACKGROUND = ClothAttributes.id("transparent_background");
    public static final FiberId CATEGORY_BACKGROUND = ClothAttributes.id("category_background");
    public static final FiberId EXCLUDED = ClothAttributes.id("excluded");
    public static final FiberId GROUP_DISPLAY = ClothAttributes.id("group_display");
    public static final FiberId SUGGESTION_ENUM = ClothAttributes.id("suggestion");
    public static final FiberId SLIDER = ClothAttributes.id("slider");
    public static final FiberId COLOR_PICKER = ClothAttributes.id("color_picker");
    public static final FiberId REGISTRY_INPUT = ClothAttributes.id("registry_object");
    public static final FiberId REQUIRES_RESTART = ClothAttributes.id("requires_restart");
    public static final FiberId PREFIX_TEXT = ClothAttributes.id("prefix_text");
    public static final FiberId TOOLTIP = ClothAttributes.id("tooltip");

    public static ConfigAttribute<String> defaultBackground(class_2960 backgroundLocation) {
        return ConfigAttribute.create(DEFAULT_BACKGROUND, DefaultTypes.IDENTIFIER_TYPE, backgroundLocation);
    }

    public static ConfigAttribute<Boolean> transparentBackground() {
        return ConfigAttribute.create(TRANSPARENT_BACKGROUND, ConfigTypes.BOOLEAN, true);
    }

    public static ConfigAttribute<String> categoryBackground(class_2960 backgroundLocation) {
        return ConfigAttribute.create(CATEGORY_BACKGROUND, DefaultTypes.IDENTIFIER_TYPE, backgroundLocation);
    }

    public static ConfigAttribute<Boolean> excluded() {
        return ConfigAttribute.create(EXCLUDED, ConfigTypes.BOOLEAN, true);
    }

    public static ConfigAttribute<String> collapsible(boolean startExpanded) {
        return ConfigAttribute.create(GROUP_DISPLAY, GroupDisplayOption.TYPE, startExpanded ? GroupDisplayOption.COLLAPSIBLE_EXPANDED : GroupDisplayOption.COLLAPSIBLE);
    }

    public static ConfigAttribute<String> transitive() {
        return ConfigAttribute.create(GROUP_DISPLAY, GroupDisplayOption.TYPE, GroupDisplayOption.TRANSITIVE);
    }

    public static ConfigAttribute<String> enumDisplay(ClothSetting.EnumHandler.EnumDisplayOption value) {
        return ConfigAttribute.create(SUGGESTION_ENUM, Fiber2ClothImpl.ENUM_DISPLAY_TYPE, value);
    }

    public static ConfigAttribute<Boolean> slider() {
        return ConfigAttribute.create(SLIDER, ConfigTypes.BOOLEAN, true);
    }

    public static ConfigAttribute<String> colorPicker(boolean alpha) {
        return ConfigAttribute.create(COLOR_PICKER, ColorPickerFormat.TYPE, alpha ? ColorPickerFormat.ARGB : ColorPickerFormat.RGB);
    }

    public static ConfigAttribute<String> registryInput(class_2385<?> registry) {
        class_2960 registryId = class_2378.field_11144.method_10221(registry);
        if (registryId == null) {
            throw new IllegalArgumentException("Unregistered registry " + registry);
        }
        return ClothAttributes.registryInput(registryId);
    }

    public static ConfigAttribute<String> registryInput(class_2960 registryId) {
        return ConfigAttribute.create(REGISTRY_INPUT, DefaultTypes.IDENTIFIER_TYPE, registryId);
    }

    public static ConfigAttribute<Boolean> requiresRestart() {
        return ConfigAttribute.create(REQUIRES_RESTART, ConfigTypes.BOOLEAN, true);
    }

    public static ConfigAttribute<String> prefixText(String prefixKey) {
        return ConfigAttribute.create(PREFIX_TEXT, ConfigTypes.STRING, prefixKey);
    }

    public static ConfigAttribute<String> tooltip() {
        return ClothAttributes.tooltip(null);
    }

    public static ConfigAttribute<String> tooltip(String tooltipKey) {
        return ConfigAttribute.create(TOOLTIP, ConfigTypes.STRING, tooltipKey == null ? "" : tooltipKey);
    }

    private static FiberId id(String name) {
        return new FiberId("fiber2cloth", name);
    }

    private ClothAttributes() {
    }
}

