/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.whisperwoods.client.init;

import com.google.common.collect.ImmutableMap;
import dev.architectury.event.events.client.ClientReloadShadersEvent;
import dev.architectury.platform.Platform;
import dev.architectury.registry.client.rendering.BlockEntityRendererRegistry;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import dev.itsmeow.whisperwoods.WhisperwoodsMod;
import dev.itsmeow.whisperwoods.client.particle.FlameParticle;
import dev.itsmeow.whisperwoods.client.particle.WispParticle;
import dev.itsmeow.whisperwoods.client.renderer.entity.RenderHirschgeist;
import dev.itsmeow.whisperwoods.client.renderer.entity.RenderWisp;
import dev.itsmeow.whisperwoods.client.renderer.entity.layer.LayerEyesSwitching;
import dev.itsmeow.whisperwoods.client.renderer.entity.model.ModelHidebehind;
import dev.itsmeow.whisperwoods.client.renderer.entity.model.ModelHirschgeist;
import dev.itsmeow.whisperwoods.client.renderer.entity.model.ModelMoth;
import dev.itsmeow.whisperwoods.client.renderer.entity.model.ModelZotzpyre;
import dev.itsmeow.whisperwoods.client.renderer.tile.RenderHGSkull;
import dev.itsmeow.whisperwoods.client.renderer.tile.RenderTileGhostLight;
import dev.itsmeow.whisperwoods.client.renderer.tile.RenderTileHandOfFate;
import dev.itsmeow.whisperwoods.client.renderer.tile.model.ModelHGSkull;
import dev.itsmeow.whisperwoods.client.renderer.tile.model.ModelHGSkullMask;
import dev.itsmeow.whisperwoods.client.renderer.tile.model.ModelHandOfFate;
import dev.itsmeow.whisperwoods.entity.EntityHidebehind;
import dev.itsmeow.whisperwoods.entity.projectile.EntityHirschgeistFireball;
import dev.itsmeow.whisperwoods.imdlib.client.IMDLibClient;
import dev.itsmeow.whisperwoods.imdlib.client.render.RenderFactory;
import dev.itsmeow.whisperwoods.init.ModBlockEntities;
import dev.itsmeow.whisperwoods.init.ModBlocks;
import dev.itsmeow.whisperwoods.init.ModEntities;
import dev.itsmeow.whisperwoods.init.ModParticles;
import dev.itsmeow.whisperwoods.init.ModResources;
import java.io.IOException;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2591;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4002;
import net.minecraft.class_4050;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4668;
import net.minecraft.class_5601;
import net.minecraft.class_5607;
import net.minecraft.class_5944;
import net.minecraft.class_707;
import net.minecraft.class_897;
import org.apache.logging.log4j.LogManager;

public class ClientLifecycleHandler {
    public static RenderFactory R = IMDLibClient.getRenderRegistry("whisperwoods");

    public static void clientInit() {
        ClientReloadShadersEvent.EVENT.register((resourceManager, shadersSink) -> {
            try {
                shadersSink.registerShader(new class_5944(resourceManager, "ww_rendertype_eyes_custom", class_290.field_1580), shaderInstance -> {
                    RenderTypeAddition.eyesCustomShader = shaderInstance;
                });
            }
            catch (IOException e) {
                WhisperwoodsMod.LOGGER.error((Object)e);
            }
        });
        BlockEntityRendererRegistry.register((class_2591)((class_2591)ModBlockEntities.GHOST_LIGHT.get()), RenderTileGhostLight::new);
        BlockEntityRendererRegistry.register((class_2591)((class_2591)ModBlockEntities.HG_SKULL.get()), RenderHGSkull::new);
        BlockEntityRendererRegistry.register((class_2591)((class_2591)ModBlockEntities.HAND_OF_FATE.get()), RenderTileHandOfFate::new);
        RenderTypeRegistry.register((class_1921)class_1921.method_23583(), (class_2248[])new class_2248[]{(class_2248)ModBlocks.WISP_LANTERN_BLUE.get(), (class_2248)ModBlocks.WISP_LANTERN_GREEN.get(), (class_2248)ModBlocks.WISP_LANTERN_ORANGE.get(), (class_2248)ModBlocks.WISP_LANTERN_PURPLE.get(), (class_2248)ModBlocks.WISP_LANTERN_YELLOW.get()});
        if (Platform.isFabric()) {
            ClientLifecycleHandler.registerEntityRenders();
        }
        LogManager.getLogger().info("Increasing wispiness of wisps...");
    }

    public static void registerEntityRenders() {
        R.addRender(ModEntities.MOTH::getEntityType, 0.1f, r -> r.tVariant().mSingle(ModelMoth::new, "moth").simpleScale(e -> Float.valueOf(e.method_18377((class_4050)class_4050.field_18076).field_18067)));
        R.addRender(ModEntities.HIDEBEHIND::getEntityType, 0.75f, r -> r.tVariant().mSingle(ModelHidebehind::new, "hidebehind").renderLayer((e, a, b, c, t) -> class_1921.method_24294((class_2960)t, (boolean)true)).layer(t -> new LayerEyesSwitching(t, EntityHidebehind::getOpen, ModResources.HIDEBEHIND_OPEN_GLOW, ModResources.HIDEBEHIND_GLOW)));
        RenderFactory.addRender(ModEntities.WISP::getEntityType, RenderWisp::new);
        RenderFactory.addRender(ModEntities.HIRSCHGEIST::getEntityType, RenderHirschgeist::new);
        RenderFactory.addRender(() -> ModEntities.PROJECTILE_HIRSCHGEIST_FIREBALL.get(), t -> new class_897<EntityHirschgeistFireball>(t){

            public void render(EntityHirschgeistFireball entity, float f, float g, class_4587 poseStack, class_4597 multiBufferSource, int i) {
                if (!class_310.method_1551().method_1493() && System.nanoTime() - entity.lastSpawn >= 10000000L) {
                    entity.lastSpawn = System.nanoTime();
                    for (int j = 0; j < 5; ++j) {
                        double xO = entity.method_37908().method_8409().method_43057() * 2.0f - 1.0f;
                        double yO = entity.method_37908().method_8409().method_43057() * 2.0f - 1.0f;
                        double zO = entity.method_37908().method_8409().method_43057() * 2.0f - 1.0f;
                        entity.method_37908().method_8406((class_2394)ModParticles.SOUL_FLAME.get(), entity.method_23317() + xO, entity.method_23318() + yO, entity.method_23321() + zO, 0.0, (double)0.005f, 0.0);
                    }
                }
            }

            public class_2960 getTextureLocation(EntityHirschgeistFireball entity) {
                return null;
            }
        });
        R.addRender(ModEntities.ZOTZPYRE::getEntityType, 0.4f, r -> r.tVariant().mSingle(ModelZotzpyre::new, "zotzpyre").layer(t -> new LayerEyesSwitching(t, e -> "6".equals(e.getVariantNameOrEmpty()), ModResources.ZOTZPYRE_6_EYES, ModResources.ZOTZPYRE_EYES)));
    }

    public static void layerDefinitions(ImmutableMap.Builder<class_5601, class_5607> b) {
        BiConsumer<String, class_5607> r = (k, l) -> b.put((Object)new class_5601(new class_2960("whisperwoods", k), "main"), l);
        r.accept("moth", ModelMoth.createBodyLayer());
        r.accept("hidebehind", ModelHidebehind.createBodyLayer());
        r.accept("hirschgeist", ModelHirschgeist.createBodyLayer());
        r.accept("zotzpyre", ModelZotzpyre.createBodyLayer());
        r.accept("hirschgeist_skull", ModelHGSkull.createBodyLayer());
        r.accept("hand_of_fate", ModelHandOfFate.createBodyLayer());
        r.accept("hirschgeist_skull_mask", ModelHGSkullMask.createBodyLayer());
    }

    public static void registerParticles(BiConsumer<class_2396<?>, Function<class_4002, class_707<?>>> register) {
        register.accept((class_2396)ModParticles.WISP.get(), WispParticle.WispFactory::new);
        register.accept((class_2396)ModParticles.FLAME.get(), FlameParticle.FlameFactory::new);
        register.accept((class_2396)ModParticles.SOUL_FLAME.get(), FlameParticle.FlameFactory::new);
    }

    public static class RenderTypeAddition
    extends class_1921 {
        private static class_5944 eyesCustomShader;
        private static final class_4668.class_5942 RENDERTYPE_WW_EYES_ENTITY_CUTOUT_NO_CULL_DEPTH_MASK_OFF;
        private static final Function<class_2960, class_1921> WW_EYES_ENTITY_CUTOUT_NO_CULL_DEPTH_MASK_OFF;

        private RenderTypeAddition() {
            super(null, null, class_293.class_5596.field_27382, 0, false, false, null, null);
        }

        public static class_1921 getEyesEntityCutoutNoCullDepthMaskOff(class_2960 l) {
            return WW_EYES_ENTITY_CUTOUT_NO_CULL_DEPTH_MASK_OFF.apply(l);
        }

        static {
            RENDERTYPE_WW_EYES_ENTITY_CUTOUT_NO_CULL_DEPTH_MASK_OFF = new class_4668.class_5942(() -> eyesCustomShader);
            WW_EYES_ENTITY_CUTOUT_NO_CULL_DEPTH_MASK_OFF = class_156.method_34866(resourceLocation -> RenderTypeAddition.method_24049((String)"ww_eyes_entity_cutout_no_cull_depth_mask_off", (class_293)class_290.field_1580, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (boolean)false, (boolean)true, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34578(RENDERTYPE_WW_EYES_ENTITY_CUTOUT_NO_CULL_DEPTH_MASK_OFF).method_34577((class_4668.class_5939)new class_4668.class_4683(resourceLocation, false, false)).method_23603(field_21345).method_23615(field_21366).method_23616(field_21350).method_23608(field_21384).method_23611(field_21385).method_23617(false)));
        }
    }
}

