/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.ai.relationship;

import forge.net.mca.Config;
import forge.net.mca.entity.EntitiesMCA;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.ZombieVillagerEntityMCA;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;

public enum Gender {
    UNASSIGNED(0xFFFFFF, "unassigned"),
    MALE(108266, "male"),
    FEMALE(10897828, "female"),
    NEUTRAL(0xFFFFFF, "neutral");

    private static final RandomSource RNG;
    private static final Gender[] VALUES;
    private static final Map<String, Gender> REGISTRY;
    private final int color;
    private final String dataName;

    private Gender(int color, String dataName) {
        this.color = color;
        this.dataName = dataName;
    }

    public EntityType<VillagerEntityMCA> getVillagerType() {
        return this == FEMALE ? (EntityType)EntitiesMCA.FEMALE_VILLAGER.get() : (EntityType)EntitiesMCA.MALE_VILLAGER.get();
    }

    public EntityType<ZombieVillagerEntityMCA> getZombieType() {
        return this == FEMALE ? (EntityType)EntitiesMCA.FEMALE_ZOMBIE_VILLAGER.get() : (EntityType)EntitiesMCA.MALE_ZOMBIE_VILLAGER.get();
    }

    public int getColor() {
        return this.color;
    }

    public int getId() {
        return this.ordinal();
    }

    public String getDataName() {
        return this.dataName;
    }

    public Gender binary() {
        return this == FEMALE ? FEMALE : MALE;
    }

    public Gender opposite() {
        return this == FEMALE ? MALE : FEMALE;
    }

    public static Gender byId(int id) {
        if (id < 0 || id >= VALUES.length) {
            return UNASSIGNED;
        }
        return VALUES[id];
    }

    public static Gender getRandom() {
        return RNG.m_188499_() ? MALE : FEMALE;
    }

    public static Gender byName(String name) {
        return REGISTRY.getOrDefault(name.toUpperCase(Locale.ENGLISH), UNASSIGNED);
    }

    public float getHorizontalScaleFactor() {
        return this == FEMALE ? Config.getInstance().femaleVillagerWidthFactor : (this == MALE ? Config.getInstance().maleVillagerWidthFactor : (Config.getInstance().femaleVillagerWidthFactor + Config.getInstance().maleVillagerWidthFactor) * 0.5f);
    }

    public float getScaleFactor() {
        return this == FEMALE ? Config.getInstance().femaleVillagerHeightFactor : (this == MALE ? Config.getInstance().maleVillagerHeightFactor : (Config.getInstance().femaleVillagerHeightFactor + Config.getInstance().maleVillagerHeightFactor) * 0.5f);
    }

    public static Component getText(Gender t) {
        return Component.m_237115_((String)("gui.villager_editor." + t.name().toLowerCase(Locale.ROOT)));
    }

    static {
        RNG = RandomSource.m_216327_();
        VALUES = Gender.values();
        REGISTRY = Stream.of(VALUES).collect(Collectors.toMap(Enum::name, Function.identity()));
    }
}

