/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity;

import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import forge.net.mca.ProfessionsMCA;
import forge.net.mca.entity.CribEntity;
import forge.net.mca.entity.GrimReaperEntity;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.ZombieVillagerEntityMCA;
import forge.net.mca.entity.ai.ActivityMCA;
import forge.net.mca.entity.ai.MemoryModuleTypeMCA;
import forge.net.mca.entity.ai.SchedulesMCA;
import forge.net.mca.entity.ai.relationship.Gender;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombieVillager;

public interface EntitiesMCA {
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((String)"mca", (ResourceKey)Registries.f_256939_);
    public static final RegistrySupplier<EntityType<VillagerEntityMCA>> MALE_VILLAGER = EntitiesMCA.register("male_villager", EntityType.Builder.m_20704_((t, w) -> new VillagerEntityMCA((EntityType<VillagerEntityMCA>)t, w, Gender.MALE), (MobCategory)MobCategory.AMBIENT).m_20699_(0.6f, 2.0f), VillagerEntityMCA::createVillagerAttributes);
    public static final RegistrySupplier<EntityType<VillagerEntityMCA>> FEMALE_VILLAGER = EntitiesMCA.register("female_villager", EntityType.Builder.m_20704_((t, w) -> new VillagerEntityMCA((EntityType<VillagerEntityMCA>)t, w, Gender.FEMALE), (MobCategory)MobCategory.AMBIENT).m_20699_(0.6f, 2.0f), VillagerEntityMCA::createVillagerAttributes);
    public static final RegistrySupplier<EntityType<ZombieVillagerEntityMCA>> MALE_ZOMBIE_VILLAGER = EntitiesMCA.register("male_zombie_villager", EntityType.Builder.m_20704_((t, w) -> new ZombieVillagerEntityMCA((EntityType<? extends ZombieVillager>)t, w, Gender.MALE), (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 2.0f), Zombie::m_34328_);
    public static final RegistrySupplier<EntityType<ZombieVillagerEntityMCA>> FEMALE_ZOMBIE_VILLAGER = EntitiesMCA.register("female_zombie_villager", EntityType.Builder.m_20704_((t, w) -> new ZombieVillagerEntityMCA((EntityType<? extends ZombieVillager>)t, w, Gender.FEMALE), (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 2.0f), Zombie::m_34328_);
    public static final RegistrySupplier<EntityType<GrimReaperEntity>> GRIM_REAPER = EntitiesMCA.register("grim_reaper", EntityType.Builder.m_20704_(GrimReaperEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(1.0f, 2.6f).m_20719_(), GrimReaperEntity::createAttributes);
    public static final RegistrySupplier<EntityType<CribEntity>> CRIB = EntitiesMCA.registerNonLiving("crib", EntityType.Builder.m_20704_((t, w) -> new CribEntity((EntityType<? extends CribEntity>)t, w), (MobCategory)MobCategory.MISC).m_20699_(1.2f, 1.0f).m_20719_());

    public static void bootstrap() {
        ENTITY_TYPES.register();
        MemoryModuleTypeMCA.bootstrap();
        ActivityMCA.bootstrap();
        SchedulesMCA.bootstrap();
        ProfessionsMCA.bootstrap();
    }

    public static <T extends Entity> RegistrySupplier<EntityType<T>> registerNonLiving(String name, EntityType.Builder<T> builder) {
        ResourceLocation id = new ResourceLocation("mca", name);
        return ENTITY_TYPES.register(id, () -> {
            EntityType result = builder.m_20712_(id.toString());
            return result;
        });
    }

    public static <T extends LivingEntity> RegistrySupplier<EntityType<T>> register(String name, EntityType.Builder<T> builder, Supplier<AttributeSupplier.Builder> attributes) {
        ResourceLocation id = new ResourceLocation("mca", name);
        return ENTITY_TYPES.register(id, () -> {
            EntityType result = builder.m_20712_(id.toString());
            EntityAttributeRegistry.register(() -> result, (Supplier)attributes);
            return result;
        });
    }
}

