/*
 * Decompiled with CFR 0.152.
 */
package fabric.net.mca.entity.ai;

import fabric.net.mca.Config;
import fabric.net.mca.TagsMCA;
import fabric.net.mca.block.BlocksMCA;
import fabric.net.mca.block.TombstoneBlock;
import fabric.net.mca.entity.VillagerEntityMCA;
import fabric.net.mca.entity.VillagerLike;
import fabric.net.mca.entity.ai.ActivityMCA;
import fabric.net.mca.entity.ai.relationship.CompassionateEntity;
import fabric.net.mca.entity.ai.relationship.EntityRelationship;
import fabric.net.mca.entity.ai.relationship.Gender;
import fabric.net.mca.entity.ai.relationship.RelationshipType;
import fabric.net.mca.entity.interaction.gifts.GiftSaturation;
import fabric.net.mca.server.world.data.FamilyTree;
import fabric.net.mca.server.world.data.FamilyTreeNode;
import fabric.net.mca.server.world.data.GraveyardManager;
import fabric.net.mca.util.WorldUtils;
import fabric.net.mca.util.network.datasync.CDataManager;
import fabric.net.mca.util.network.datasync.CParameter;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiPredicate;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4099;
import net.minecraft.class_4140;
import net.minecraft.class_4142;
import net.minecraft.class_4168;
import net.minecraft.class_8111;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Relationship<T extends class_1308>
implements EntityRelationship {
    public static final Predicate IS_MARRIED = (villager, player) -> villager.getRelationships().isMarriedTo(player);
    public static final Predicate IS_ENGAGED = (villager, player) -> villager.getRelationships().isEngagedWith(player);
    public static final Predicate IS_PROMISED = (villager, player) -> villager.getRelationships().isPromisedTo(player);
    public static final Predicate IS_RELATIVE = (villager, player) -> villager.getRelationships().getFamilyEntry().isRelative(player);
    public static final Predicate IS_FAMILY = IS_MARRIED.or(IS_RELATIVE);
    public static final Predicate IS_PARENT = (villager, player) -> villager.getRelationships().getFamilyEntry().isParent(player);
    public static final Predicate IS_KID = (villager, player) -> FamilyTree.get(villager.getRelationships().getWorld()).getOrEmpty(player).filter(n -> n.isParent(villager.getRelationships().getUUID())).isPresent();
    public static final Predicate IS_ORPHAN = (villager, player) -> villager.getRelationships().getFamilyEntry().getParents().allMatch(FamilyTreeNode::isDeceased);
    protected final T entity;
    private final GiftSaturation giftSaturation = new GiftSaturation();

    public static <E extends class_1297> CDataManager.Builder<E> createTrackedData(CDataManager.Builder<E> builder) {
        return builder.addAll(new CParameter[0]);
    }

    public Relationship(T entity) {
        this.entity = entity;
    }

    @Override
    public Gender getGender() {
        return ((VillagerLike)this.entity).getGenetics().getGender();
    }

    @Override
    public class_3218 getWorld() {
        return (class_3218)this.entity.method_37908();
    }

    @Override
    public UUID getUUID() {
        return this.entity.method_5667();
    }

    @Override
    @NotNull
    public FamilyTreeNode getFamilyEntry() {
        return this.getFamilyTree().getOrCreate((class_1297)this.entity);
    }

    private Optional<class_2338> placeTombstone(class_3218 world, class_2338 entityPos) {
        int range = 2;
        for (int y = -range; y <= range; ++y) {
            class_2338 pos = entityPos.method_10069(0, y, 0);
            if (world.method_8320(pos).method_26215()) {
                world.method_8501(pos, ((class_2248)BlocksMCA.CROSS_HEADSTONE.get()).method_9564());
                return Optional.ofNullable(pos);
            }
            for (int x = -range; x <= range; ++x) {
                for (int z = -range; z <= range; ++z) {
                    if (x == 0 && z == 0 || !world.method_8320(pos = entityPos.method_10069(x, y, z)).method_26215()) continue;
                    world.method_8501(pos, ((class_2248)BlocksMCA.CROSS_HEADSTONE.get()).method_9564());
                    return Optional.ofNullable(pos);
                }
            }
        }
        return Optional.empty();
    }

    public void onDeath(class_1282 cause) {
        boolean beRemembered = this.getFamilyEntry().willBeRemembered();
        boolean beLoved = ((VillagerLike)this.entity).getVillagerBrain().getMemories().values().stream().anyMatch(m -> m.getHearts() > Config.getInstance().heartsRequiredToAutoSpawnGravestone);
        if (beRemembered || beLoved || !((VillagerLike)this.entity).isHostile()) {
            this.getFamilyEntry().setDeceased(true);
            class_3218 world = (class_3218)this.entity.method_37908();
            Optional<class_2338> nearest = GraveyardManager.get(world).findNearest(this.entity.method_24515(), GraveyardManager.TombstoneState.EMPTY, 10);
            if ((beRemembered || beLoved) && nearest.isEmpty()) {
                nearest = this.placeTombstone(world, this.entity.method_24515());
            }
            nearest.ifPresentOrElse(pos -> {
                class_2586 be;
                if (this.entity.method_37908().method_8320(pos).method_26164(TagsMCA.Blocks.TOMBSTONES) && (be = this.entity.method_37908().method_8321(pos)) instanceof TombstoneBlock.Data) {
                    this.onTragedy(cause, (class_2338)pos);
                    ((TombstoneBlock.Data)be).setEntity((class_1297)this.entity);
                }
                this.onTragedy(cause, null);
            }, () -> this.onTragedy(cause, null));
        } else {
            this.onTragedy(cause, null);
        }
        if (!beRemembered) {
            this.getFamilyEntry().streamParents().forEach(uuid -> this.getFamilyTree().remove((UUID)uuid));
            this.getFamilyTree().remove(this.entity.method_5667());
        }
    }

    public void onTragedy(class_1282 cause, @Nullable class_2338 burialSite) {
        if (!((VillagerLike)this.entity).isHostile()) {
            WorldUtils.getCloseEntities(this.entity.method_37908(), this.entity, 32.0, VillagerEntityMCA.class).forEach(villager -> villager.getRelationships().onTragedy(cause, burialSite, RelationshipType.STRANGER, (class_1297)this.entity));
        }
        this.onTragedy(cause, burialSite, RelationshipType.SELF, (class_1297)this.entity);
    }

    @Override
    public void onTragedy(class_1282 cause, @Nullable class_2338 burialSite, RelationshipType type, class_1297 with) {
        if (!cause.method_49708(class_8111.field_42347)) {
            int moodAffect = 5 * type.getProximityAmplifier();
            this.entity.method_37908().method_8421(this.entity, (byte)17);
            ((VillagerLike)this.entity).getVillagerBrain().modifyMoodValue(-moodAffect);
            class_1297 class_12972 = cause.method_5529();
            if (class_12972 instanceof class_1657) {
                class_1657 player = (class_1657)class_12972;
                ((VillagerLike)this.entity).getVillagerBrain().getMemoriesForPlayer(player).modHearts(-20);
            }
        }
        if (burialSite != null && type != RelationshipType.STRANGER) {
            ((VillagerLike)this.entity).getVillagerBrain().setGrieving();
            this.entity.method_18868().method_18878(class_4140.field_18445, (Object)new class_4142(burialSite, 1.0f, 1));
            this.entity.method_18868().method_18878(class_4140.field_18446, (Object)new class_4099(burialSite));
            this.entity.method_18868().method_24526((class_4168)ActivityMCA.GRIEVE.get());
        }
        EntityRelationship.super.onTragedy(cause, burialSite, type, with);
    }

    public GiftSaturation getGiftSaturation() {
        return this.giftSaturation;
    }

    public void readFromNbt(class_2487 nbt) {
        this.giftSaturation.readFromNbt(nbt.method_10554("giftSaturationQueue", 8));
    }

    public void writeToNbt(class_2487 nbt) {
        nbt.method_10566("giftSaturationQueue", (class_2520)this.giftSaturation.toNbt());
    }

    public static interface Predicate
    extends BiPredicate<CompassionateEntity<?>, class_1297> {
        @Override
        public boolean test(CompassionateEntity<?> var1, UUID var2);

        @Override
        default public boolean test(CompassionateEntity<?> villager, class_1297 partner) {
            return partner != null && this.test(villager, partner.method_5667());
        }

        default public Predicate or(Predicate b) {
            return (villager, partner) -> this.test(villager, partner) || b.test(villager, partner);
        }

        default public Predicate negate() {
            return (villager, partner) -> !this.test(villager, partner);
        }

        default public BiPredicate<VillagerLike<?>, class_3222> asConstraint() {
            return (villager, player) -> villager instanceof CompassionateEntity && this.test((CompassionateEntity)((Object)villager), (class_1297)player);
        }
    }
}

