/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.util.workarounds.driver.nvidia;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.jellysquid.mods.sodium.client.util.workarounds.GLContextInfo;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;

public record NvidiaGLContextInfo(int major, int minor) {
    private static final Pattern PATTERN = Pattern.compile("^.*NVIDIA (?<major>\\d+)\\.(?<minor>\\d+)(?<suffix>\\.\\d+)?$");

    @Nullable
    public static NvidiaGLContextInfo tryParse(GLContextInfo driver) {
        int minor;
        int major;
        if (!Objects.equals(driver.vendor(), "NVIDIA Corporation")) {
            return null;
        }
        Matcher matcher = PATTERN.matcher(driver.version());
        if (!matcher.matches()) {
            return null;
        }
        try {
            major = Integer.parseInt(matcher.group("major"));
            minor = Integer.parseInt(matcher.group("minor"));
        }
        catch (NumberFormatException e) {
            return null;
        }
        return new NvidiaGLContextInfo(major, minor);
    }

    public boolean isWithinRange(NvidiaGLContextInfo oldest, NvidiaGLContextInfo newest) {
        return this.asInteger() >= oldest.asInteger() && this.asInteger() < newest.asInteger();
    }

    private long asInteger() {
        Validate.isTrue((this.major >= 0 ? 1 : 0) != 0);
        Validate.isTrue((this.minor >= 0 ? 1 : 0) != 0);
        return Integer.toUnsignedLong(this.major) << 32 | Integer.toUnsignedLong(this.minor) << 0;
    }
}

