/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.particles;

import io.wispforest.owo.util.VectorRandomUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_703;

@Environment(value=EnvType.CLIENT)
public final class ClientParticles {
    private static int particleCount = 1;
    private static boolean persist = false;
    private static class_243 velocity = new class_243(0.0, 0.0, 0.0);
    private static boolean randomizeVelocity = false;
    private static double randomVelocityScalar = 0.0;
    private static class_2350.class_2351 randomizationAxis = null;

    private ClientParticles() {
    }

    public static void persist() {
        persist = true;
    }

    public static void setParticleCount(int particleCount) {
        ClientParticles.particleCount = particleCount;
    }

    public static void setVelocity(class_243 velocity) {
        ClientParticles.velocity = velocity;
    }

    public static void randomizeVelocity(double scalar) {
        randomizeVelocity = true;
        randomVelocityScalar = scalar;
        randomizationAxis = null;
    }

    public static void randomizeVelocityOnAxis(double scalar, class_2350.class_2351 axis) {
        randomizeVelocity = true;
        randomVelocityScalar = scalar;
        randomizationAxis = axis;
    }

    public static void reset() {
        persist = false;
        ClientParticles.clearState();
    }

    private static void clearState() {
        if (persist) {
            return;
        }
        particleCount = 1;
        velocity = new class_243(0.0, 0.0, 0.0);
        randomizeVelocity = false;
    }

    private static void addParticle(class_2394 particle, class_1937 world, class_243 location) {
        if (randomizeVelocity) {
            if (randomizationAxis == null) {
                velocity = VectorRandomUtils.getRandomOffset(world, class_243.field_1353, randomVelocityScalar);
            } else {
                double stopIt_getSomeHelp = (world.field_9229.method_43058() * 2.0 - 1.0) * randomVelocityScalar;
                velocity = switch (randomizationAxis) {
                    default -> throw new IncompatibleClassChangeError();
                    case class_2350.class_2351.field_11048 -> new class_243(stopIt_getSomeHelp, 0.0, 0.0);
                    case class_2350.class_2351.field_11052 -> new class_243(0.0, stopIt_getSomeHelp, 0.0);
                    case class_2350.class_2351.field_11051 -> new class_243(0.0, 0.0, stopIt_getSomeHelp);
                };
            }
        }
        world.method_8406(particle, location.field_1352, location.field_1351, location.field_1350, ClientParticles.velocity.field_1352, ClientParticles.velocity.field_1351, ClientParticles.velocity.field_1350);
    }

    public static void spawnCenteredOnBlock(class_2394 particle, class_1937 world, class_2338 pos, double deviation) {
        for (int i = 0; i < particleCount; ++i) {
            class_243 location = VectorRandomUtils.getRandomCenteredOnBlock(world, pos, deviation);
            ClientParticles.addParticle(particle, world, location);
        }
        ClientParticles.clearState();
    }

    public static void spawnWithinBlock(class_2394 particle, class_1937 world, class_2338 pos) {
        for (int i = 0; i < particleCount; ++i) {
            class_243 location = VectorRandomUtils.getRandomWithinBlock(world, pos);
            ClientParticles.addParticle(particle, world, location);
        }
        ClientParticles.clearState();
    }

    public static void spawnWithOffsetFromBlock(class_2394 particle, class_1937 world, class_2338 pos, class_243 offset, double deviation) {
        offset = offset.method_1019(class_243.method_24954((class_2382)pos));
        for (int i = 0; i < particleCount; ++i) {
            class_243 location = VectorRandomUtils.getRandomOffset(world, offset, deviation);
            ClientParticles.addParticle(particle, world, location);
        }
        ClientParticles.clearState();
    }

    public static void spawn(class_2394 particle, class_1937 world, class_243 pos, double deviation) {
        for (int i = 0; i < particleCount; ++i) {
            class_243 location = VectorRandomUtils.getRandomOffset(world, pos, deviation);
            ClientParticles.addParticle(particle, world, location);
        }
        ClientParticles.clearState();
    }

    public static void spawnPrecise(class_2394 particle, class_1937 world, class_243 pos, double deviationX, double deviationY, double deviationZ) {
        for (int i = 0; i < particleCount; ++i) {
            class_243 location = VectorRandomUtils.getRandomOffsetSpecific(world, pos, deviationX, deviationY, deviationZ);
            ClientParticles.addParticle(particle, world, location);
        }
        ClientParticles.clearState();
    }

    public static void spawnEnchantParticles(class_1937 world, class_243 origin, class_243 destination, float deviation) {
        class_243 particleVector = origin.method_1020(destination);
        for (int i = 0; i < particleCount; ++i) {
            class_243 location = VectorRandomUtils.getRandomOffset(world, particleVector, deviation);
            world.method_8406((class_2394)class_2398.field_11215, destination.field_1352, destination.field_1351, destination.field_1350, location.field_1352, location.field_1351, location.field_1350);
        }
        ClientParticles.clearState();
    }

    public static <T extends class_2394> void spawnWithMaxAge(T particleType, class_243 pos, int maxAge) {
        class_703 particle = class_310.method_1551().field_1713.method_3056(particleType, pos.field_1352, pos.field_1351, pos.field_1350, ClientParticles.velocity.field_1352, ClientParticles.velocity.field_1351, ClientParticles.velocity.field_1350);
        particle.method_3077(maxAge);
        ClientParticles.clearState();
    }

    public static void spawnLine(class_2394 particle, class_1937 world, class_243 start, class_243 end, float deviation) {
        ClientParticles.spawnLineInner(particle, world, start, end, deviation);
        ClientParticles.clearState();
    }

    public static void spawnCubeOutline(class_2394 particle, class_1937 world, class_243 origin, float size, float deviation) {
        ClientParticles.spawnLineInner(particle, world, origin, origin.method_1031((double)size, 0.0, 0.0), deviation);
        ClientParticles.spawnLineInner(particle, world, origin.method_1031((double)size, 0.0, 0.0), origin.method_1031((double)size, 0.0, (double)size), deviation);
        ClientParticles.spawnLineInner(particle, world, origin, origin.method_1031(0.0, 0.0, (double)size), deviation);
        ClientParticles.spawnLineInner(particle, world, origin.method_1031(0.0, 0.0, (double)size), origin.method_1031((double)size, 0.0, (double)size), deviation);
        origin = origin.method_1031(0.0, (double)size, 0.0);
        ClientParticles.spawnLineInner(particle, world, origin, origin.method_1031((double)size, 0.0, 0.0), deviation);
        ClientParticles.spawnLineInner(particle, world, origin.method_1031((double)size, 0.0, 0.0), origin.method_1031((double)size, 0.0, (double)size), deviation);
        ClientParticles.spawnLineInner(particle, world, origin, origin.method_1031(0.0, 0.0, (double)size), deviation);
        ClientParticles.spawnLineInner(particle, world, origin.method_1031(0.0, 0.0, (double)size), origin.method_1031((double)size, 0.0, (double)size), deviation);
        ClientParticles.spawnLineInner(particle, world, origin, origin.method_1031(0.0, (double)(-size), 0.0), deviation);
        ClientParticles.spawnLineInner(particle, world, origin.method_1031((double)size, 0.0, 0.0), origin.method_1031((double)size, (double)(-size), 0.0), deviation);
        ClientParticles.spawnLineInner(particle, world, origin.method_1031(0.0, 0.0, (double)size), origin.method_1031(0.0, (double)(-size), (double)size), deviation);
        ClientParticles.spawnLineInner(particle, world, origin.method_1031((double)size, 0.0, (double)size), origin.method_1031((double)size, (double)(-size), (double)size), deviation);
        ClientParticles.clearState();
    }

    private static void spawnLineInner(class_2394 particle, class_1937 world, class_243 start, class_243 end, float deviation) {
        class_243 increment = end.method_1020(start).method_1021((double)(1.0f / (float)particleCount));
        for (int i = 0; i < particleCount; ++i) {
            start = VectorRandomUtils.getRandomOffset(world, start, deviation);
            ClientParticles.addParticle(particle, world, start);
            start = start.method_1019(increment);
        }
    }
}

